/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.load_balancing.filters;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.neo4j.causalclustering.load_balancing.filters.Filter;

public class MinimumCountFilter<T>
implements Filter<T> {
    private final int minCount;

    public MinimumCountFilter(int minCount) {
        this.minCount = minCount;
    }

    @Override
    public Set<T> apply(Set<T> data) {
        return data.size() >= this.minCount ? data : Collections.emptySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MinimumCountFilter that = (MinimumCountFilter)o;
        return this.minCount == that.minCount;
    }

    public int hashCode() {
        return Objects.hash(this.minCount);
    }

    public String toString() {
        return "MinimumCountFilter{minCount=" + this.minCount + '}';
    }
}

