/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.load_balancing;

import java.util.List;
import java.util.Objects;
import org.neo4j.causalclustering.load_balancing.Endpoint;
import org.neo4j.causalclustering.load_balancing.LoadBalancingProcessor;

public class LoadBalancingResult
implements LoadBalancingProcessor.Result {
    private final List<Endpoint> routeEndpoints;
    private final List<Endpoint> writeEndpoints;
    private final List<Endpoint> readEndpoints;
    private final long timeToLiveMillis;

    public LoadBalancingResult(List<Endpoint> routeEndpoints, List<Endpoint> writeEndpoints, List<Endpoint> readEndpoints, long timeToLiveMillis) {
        this.routeEndpoints = routeEndpoints;
        this.writeEndpoints = writeEndpoints;
        this.readEndpoints = readEndpoints;
        this.timeToLiveMillis = timeToLiveMillis;
    }

    @Override
    public long getTimeToLiveMillis() {
        return this.timeToLiveMillis;
    }

    @Override
    public List<Endpoint> routeEndpoints() {
        return this.routeEndpoints;
    }

    @Override
    public List<Endpoint> writeEndpoints() {
        return this.writeEndpoints;
    }

    @Override
    public List<Endpoint> readEndpoints() {
        return this.readEndpoints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadBalancingResult that = (LoadBalancingResult)o;
        return this.timeToLiveMillis == that.timeToLiveMillis && Objects.equals(this.routeEndpoints, that.routeEndpoints) && Objects.equals(this.writeEndpoints, that.writeEndpoints) && Objects.equals(this.readEndpoints, that.readEndpoints);
    }

    public int hashCode() {
        return Objects.hash(this.routeEndpoints, this.writeEndpoints, this.readEndpoints, this.timeToLiveMillis);
    }

    public String toString() {
        return "LoadBalancingResult{routeEndpoints=" + this.routeEndpoints + ", writeEndpoints=" + this.writeEndpoints + ", readEndpoints=" + this.readEndpoints + ", timeToLiveMillis=" + this.timeToLiveMillis + '}';
    }
}

