/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.function.Function;
import java.util.function.Predicate;
import org.neo4j.causalclustering.discovery.RetryStrategy;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class MultiRetryStrategy<I, E>
implements RetryStrategy<I, E> {
    private final long delayInMillis;
    private final long retries;
    private final LogProvider logProvider;

    public MultiRetryStrategy(long delayInMillis, long retries) {
        this(delayInMillis, retries, (LogProvider)NullLogProvider.getInstance());
    }

    public MultiRetryStrategy(long delayInMillis, long retries, LogProvider logProvider) {
        this.delayInMillis = delayInMillis;
        this.retries = retries;
        this.logProvider = logProvider;
    }

    @Override
    public E apply(I input, Function<I, E> retriable, Predicate<E> wasRetrySuccessful) {
        Log log = this.logProvider.getLog(MultiRetryStrategy.class);
        E result = retriable.apply(input);
        int currentIteration = 0;
        while (!wasRetrySuccessful.test(result) && (long)currentIteration++ < this.retries) {
            log.debug("Try attempt was unsuccessful for input: %s\n", new Object[]{input});
            try {
                Thread.sleep(this.delayInMillis);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            result = retriable.apply(input);
        }
        return result;
    }
}

