/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import com.hazelcast.nio.ssl.SSLContextFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.ssl.SslPolicy;

class HazelcastSslContextFactory
implements SSLContextFactory {
    private static final String PROTOCOL = "TLS";
    private final SslPolicy sslPolicy;
    private final Log log;

    HazelcastSslContextFactory(SslPolicy sslPolicy, LogProvider logProvider) {
        this.sslPolicy = sslPolicy;
        this.log = logProvider.getLog(this.getClass());
    }

    public void init(Properties properties) throws Exception {
    }

    public SSLContext getSSLContext() {
        KeyManagerFactory keyManagerFactory;
        SSLContext sslCtx;
        try {
            sslCtx = SSLContext.getInstance(PROTOCOL);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        try {
            keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        SecureRandom rand = new SecureRandom();
        char[] password = new char[32];
        for (int i = 0; i < password.length; ++i) {
            password[i] = (char)rand.nextInt(65536);
        }
        try {
            KeyStore keyStore = this.sslPolicy.getKeyStore(password, password);
            keyManagerFactory.init(keyStore, password);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                for (int i = 0; i < password.length; ++i) {
                    password[i] = '\u0000';
                }
                throw throwable;
            }
        }
        for (int i = 0; i < password.length; ++i) {
            password[i] = '\u0000';
        }
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        TrustManager[] trustManagers = this.sslPolicy.getTrustManagerFactory().getTrustManagers();
        try {
            sslCtx.init(keyManagers, trustManagers, null);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        if (this.sslPolicy.getTlsVersions() != null) {
            this.log.warn(String.format("Restricting TLS versions through policy not supported. System defaults for %s family will be used.", PROTOCOL));
        }
        if (this.sslPolicy.getCipherSuites() != null) {
            this.log.warn("Restricting ciphers through policy not supported. System defaults will be used.");
        }
        return sslCtx;
    }
}

