/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.Topology;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;

public class CoreTopology
implements Topology<CoreServerInfo> {
    static CoreTopology EMPTY = new CoreTopology(null, false, Collections.emptyMap());
    private final ClusterId clusterId;
    private final boolean canBeBootstrapped;
    private final Map<MemberId, CoreServerInfo> coreMembers;

    public CoreTopology(ClusterId clusterId, boolean canBeBootstrapped, Map<MemberId, CoreServerInfo> coreMembers) {
        this.clusterId = clusterId;
        this.canBeBootstrapped = canBeBootstrapped;
        this.coreMembers = new HashMap<MemberId, CoreServerInfo>(coreMembers);
    }

    @Override
    public Map<MemberId, CoreServerInfo> members() {
        return this.coreMembers;
    }

    public ClusterId clusterId() {
        return this.clusterId;
    }

    public boolean canBeBootstrapped() {
        return this.canBeBootstrapped;
    }

    public String toString() {
        return String.format("{clusterId=%s, bootstrappable=%s, coreMembers=%s}", this.clusterId, this.canBeBootstrapped(), this.coreMembers);
    }

    public Optional<MemberId> anyCoreMemberId() {
        return this.coreMembers.keySet().stream().findAny();
    }
}

