/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.snapshot;

import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.causalclustering.core.consensus.LeaderLocator;
import org.neo4j.causalclustering.core.consensus.NoLeaderFoundException;
import org.neo4j.causalclustering.core.state.CommandApplicationProcess;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateDownloader;
import org.neo4j.causalclustering.helper.TimeoutStrategy;
import org.neo4j.logging.Log;

class PersistentSnapshotDownloader
implements Runnable {
    static final String OPERATION_NAME = "download of snapshot";
    private final CommandApplicationProcess applicationProcess;
    private final LeaderLocator leaderLocator;
    private final CoreStateDownloader downloader;
    private final Log log;
    private final TimeoutStrategy.Timeout timeout;
    private volatile State state;
    private volatile boolean keepRunning;

    PersistentSnapshotDownloader(LeaderLocator leaderLocator, CommandApplicationProcess applicationProcess, CoreStateDownloader downloader, Log log, TimeoutStrategy.Timeout pauseStrategy) {
        this.applicationProcess = applicationProcess;
        this.leaderLocator = leaderLocator;
        this.downloader = downloader;
        this.log = log;
        this.timeout = pauseStrategy;
        this.state = State.INITIATED;
        this.keepRunning = true;
    }

    @Override
    public void run() {
        if (!this.moveToRunningState()) {
            return;
        }
        try {
            this.applicationProcess.pauseApplier(OPERATION_NAME);
            while (this.keepRunning) {
                try {
                    this.downloader.downloadSnapshot(this.leaderLocator.getLeader());
                    break;
                }
                catch (StoreCopyFailedException e) {
                    this.log.error(String.format("Failed to download snapshot. Retrying in %s ms.", this.timeout.getMillis()), (Throwable)e);
                }
                catch (NoLeaderFoundException e) {
                    this.log.warn("No leader found. Retrying in {} ms.", new Object[]{this.timeout.getMillis()});
                }
                Thread.sleep(this.timeout.getMillis());
                this.timeout.increment();
            }
        }
        catch (InterruptedException e) {
            this.log.error("Persistent snapshot downloader was interrupted");
        }
        finally {
            this.applicationProcess.resumeApplier(OPERATION_NAME);
            this.state = State.COMPLETED;
        }
    }

    private synchronized boolean moveToRunningState() {
        if (this.state != State.INITIATED) {
            return false;
        }
        this.state = State.RUNNING;
        return true;
    }

    void stop() throws InterruptedException {
        this.keepRunning = false;
        while (!this.hasCompleted()) {
            Thread.sleep(100L);
        }
    }

    boolean hasCompleted() {
        return this.state == State.COMPLETED;
    }

    private static enum State {
        INITIATED,
        RUNNING,
        COMPLETED;

    }
}

