/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.snapshot;

import org.neo4j.causalclustering.core.consensus.LeaderLocator;
import org.neo4j.causalclustering.core.state.CommandApplicationProcess;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateDownloader;
import org.neo4j.causalclustering.core.state.snapshot.PersistentSnapshotDownloader;
import org.neo4j.causalclustering.helper.TimeoutStrategy;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;

public class CoreStateDownloaderService
extends LifecycleAdapter {
    private final JobScheduler jobScheduler;
    private final CoreStateDownloader downloader;
    private final CommandApplicationProcess applicationProcess;
    private final Log log;
    private final TimeoutStrategy.Timeout downloaderPauseStrategy;
    private PersistentSnapshotDownloader currentJob;
    private boolean stopped;

    public CoreStateDownloaderService(JobScheduler jobScheduler, CoreStateDownloader downloader, CommandApplicationProcess applicationProcess, LogProvider logProvider, TimeoutStrategy.Timeout downloaderPauseStrategy) {
        this.jobScheduler = jobScheduler;
        this.downloader = downloader;
        this.applicationProcess = applicationProcess;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
        this.downloaderPauseStrategy = downloaderPauseStrategy;
    }

    public synchronized void scheduleDownload(LeaderLocator leaderLocator) {
        if (this.stopped) {
            return;
        }
        if (this.currentJob == null || this.currentJob.hasCompleted()) {
            this.currentJob = new PersistentSnapshotDownloader(leaderLocator, this.applicationProcess, this.downloader, this.log, this.downloaderPauseStrategy);
            this.jobScheduler.schedule(JobScheduler.Groups.downloadSnapshot, (Runnable)this.currentJob);
        }
    }

    public synchronized void stop() throws Throwable {
        this.stopped = true;
        if (this.currentJob != null) {
            this.currentJob.stop();
        }
    }
}

