/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.outcome.ConsensusOutcome;
import org.neo4j.causalclustering.core.state.CommandApplicationProcess;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateDownloaderService;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.messaging.LifecycleMessageHandler;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class RaftMessageApplier
implements LifecycleMessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage> {
    private final LocalDatabase localDatabase;
    private final Log log;
    private final RaftMachine raftMachine;
    private final CoreStateDownloaderService downloadService;
    private final CommandApplicationProcess applicationProcess;

    public RaftMessageApplier(LocalDatabase localDatabase, LogProvider logProvider, RaftMachine raftMachine, CoreStateDownloaderService downloadService, CommandApplicationProcess applicationProcess) {
        this.localDatabase = localDatabase;
        this.log = logProvider.getLog(this.getClass());
        this.raftMachine = raftMachine;
        this.downloadService = downloadService;
        this.applicationProcess = applicationProcess;
    }

    @Override
    public synchronized void handle(RaftMessages.ReceivedInstantClusterIdAwareMessage wrappedMessage) {
        try {
            ConsensusOutcome outcome = this.raftMachine.handle((RaftMessages.RaftMessage)wrappedMessage.message());
            if (outcome.needsFreshSnapshot()) {
                this.downloadService.scheduleDownload(this.raftMachine);
            } else {
                this.notifyCommitted(outcome.getCommitIndex());
            }
        }
        catch (Throwable e) {
            this.log.error("Error handling message", e);
            this.raftMachine.panic();
            this.localDatabase.panic(e);
        }
    }

    @Override
    public synchronized void start(ClusterId clusterId) {
    }

    @Override
    public synchronized void stop() {
    }

    private void notifyCommitted(long commitIndex) {
        this.applicationProcess.notifyCommitted(commitIndex);
    }
}

