/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.state.CommandApplicationProcess;
import org.neo4j.causalclustering.core.state.CoreState;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshot;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateType;
import org.neo4j.causalclustering.core.state.snapshot.RaftCoreState;

public class CoreSnapshotService {
    private static final String OPERATION_NAME = "snapshot request";
    private final CommandApplicationProcess applicationProcess;
    private final CoreState coreState;
    private final RaftLog raftLog;
    private final RaftMachine raftMachine;

    public CoreSnapshotService(CommandApplicationProcess applicationProcess, CoreState coreState, RaftLog raftLog, RaftMachine raftMachine) {
        this.applicationProcess = applicationProcess;
        this.coreState = coreState;
        this.raftLog = raftLog;
        this.raftMachine = raftMachine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CoreSnapshot snapshot() throws Exception {
        this.applicationProcess.pauseApplier(OPERATION_NAME);
        try {
            long lastApplied = this.applicationProcess.lastApplied();
            long prevTerm = this.raftLog.readEntryTerm(lastApplied);
            CoreSnapshot coreSnapshot = new CoreSnapshot(lastApplied, prevTerm);
            this.coreState.augmentSnapshot(coreSnapshot);
            coreSnapshot.add(CoreStateType.RAFT_CORE_STATE, this.raftMachine.coreState());
            CoreSnapshot coreSnapshot2 = coreSnapshot;
            return coreSnapshot2;
        }
        finally {
            this.applicationProcess.resumeApplier(OPERATION_NAME);
        }
    }

    public synchronized void installSnapshot(CoreSnapshot coreSnapshot) throws Exception {
        long snapshotPrevIndex = coreSnapshot.prevIndex();
        this.raftLog.skip(snapshotPrevIndex, coreSnapshot.prevTerm());
        this.coreState.installSnapshot(coreSnapshot);
        this.raftMachine.installCoreState((RaftCoreState)coreSnapshot.get(CoreStateType.RAFT_CORE_STATE));
        this.coreState.flush(snapshotPrevIndex);
        this.applicationProcess.installSnapshot(coreSnapshot);
        this.notifyAll();
    }

    synchronized void awaitState() throws InterruptedException {
        while (this.raftMachine.state().appendIndex() < 0L) {
            this.wait();
        }
    }
}

