/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.state.CommandApplicationProcess;
import org.neo4j.causalclustering.core.state.CoreSnapshotService;
import org.neo4j.causalclustering.core.state.machines.CoreStateMachines;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshot;
import org.neo4j.causalclustering.identity.BoundState;
import org.neo4j.causalclustering.identity.ClusterBinder;
import org.neo4j.causalclustering.messaging.LifecycleMessageHandler;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class CoreLife
implements Lifecycle {
    private final RaftMachine raftMachine;
    private final LocalDatabase localDatabase;
    private final ClusterBinder clusterBinder;
    private final CommandApplicationProcess applicationProcess;
    private final CoreStateMachines coreStateMachines;
    private final LifecycleMessageHandler<?> raftMessageHandler;
    private final CoreSnapshotService snapshotService;

    public CoreLife(RaftMachine raftMachine, LocalDatabase localDatabase, ClusterBinder clusterBinder, CommandApplicationProcess commandApplicationProcess, CoreStateMachines coreStateMachines, LifecycleMessageHandler<?> raftMessageHandler, CoreSnapshotService snapshotService) {
        this.raftMachine = raftMachine;
        this.localDatabase = localDatabase;
        this.clusterBinder = clusterBinder;
        this.applicationProcess = commandApplicationProcess;
        this.coreStateMachines = coreStateMachines;
        this.raftMessageHandler = raftMessageHandler;
        this.snapshotService = snapshotService;
    }

    public synchronized void init() throws Throwable {
        this.localDatabase.init();
    }

    public synchronized void start() throws Throwable {
        BoundState boundState = this.clusterBinder.bindToCluster();
        this.raftMessageHandler.start(boundState.clusterId());
        if (boundState.snapshot().isPresent()) {
            CoreSnapshot snapshot = boundState.snapshot().get();
            this.snapshotService.installSnapshot(snapshot);
        } else {
            this.snapshotService.awaitState();
        }
        this.localDatabase.start();
        this.coreStateMachines.installCommitProcess(this.localDatabase.getCommitProcess());
        this.applicationProcess.start();
        this.raftMachine.postRecoveryActions();
    }

    public synchronized void stop() throws Throwable {
        this.raftMachine.stopTimers();
        this.raftMessageHandler.stop();
        this.applicationProcess.stop();
        this.localDatabase.stop();
    }

    public synchronized void shutdown() throws Throwable {
        this.localDatabase.shutdown();
    }
}

