/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.causalclustering.core.replication.DistributedOperation;
import org.neo4j.function.ThrowingBiConsumer;

class CommandBatcher {
    private List<DistributedOperation> batch;
    private int maxBatchSize;
    private final ThrowingBiConsumer<Long, List<DistributedOperation>, Exception> applier;
    private long lastIndex;

    CommandBatcher(int maxBatchSize, ThrowingBiConsumer<Long, List<DistributedOperation>, Exception> applier) {
        this.batch = new ArrayList<DistributedOperation>(maxBatchSize);
        this.maxBatchSize = maxBatchSize;
        this.applier = applier;
    }

    void add(long index, DistributedOperation operation) throws Exception {
        if (this.batch.size() > 0) assert (index == this.lastIndex + 1L);
        this.batch.add(operation);
        this.lastIndex = index;
        if (this.batch.size() == this.maxBatchSize) {
            this.flush();
        }
    }

    void flush() throws Exception {
        this.applier.accept((Object)this.lastIndex, this.batch);
        this.batch.clear();
    }
}

