/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.server;

import java.io.File;
import java.time.Clock;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.neo4j.causalclustering.ReplicationModule;
import org.neo4j.causalclustering.catchup.CatchUpClient;
import org.neo4j.causalclustering.catchup.CatchupServer;
import org.neo4j.causalclustering.catchup.CheckpointerSupplier;
import org.neo4j.causalclustering.catchup.storecopy.CopiedStoreRecovery;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.catchup.storecopy.RemoteStore;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyClient;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyProcess;
import org.neo4j.causalclustering.catchup.tx.TransactionLogCatchUpFactory;
import org.neo4j.causalclustering.catchup.tx.TxPullClient;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.IdentityModule;
import org.neo4j.causalclustering.core.consensus.ConsensusModule;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.log.pruning.PruningScheduler;
import org.neo4j.causalclustering.core.consensus.membership.MembershipWaiter;
import org.neo4j.causalclustering.core.consensus.membership.MembershipWaiterLifecycle;
import org.neo4j.causalclustering.core.state.ClusteringModule;
import org.neo4j.causalclustering.core.state.CommandApplicationProcess;
import org.neo4j.causalclustering.core.state.CoreLife;
import org.neo4j.causalclustering.core.state.CoreSnapshotService;
import org.neo4j.causalclustering.core.state.CoreState;
import org.neo4j.causalclustering.core.state.LongIndexMarshal;
import org.neo4j.causalclustering.core.state.RaftLogPruner;
import org.neo4j.causalclustering.core.state.machines.CoreStateMachinesModule;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateDownloader;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateDownloaderService;
import org.neo4j.causalclustering.core.state.storage.DurableStateStorage;
import org.neo4j.causalclustering.core.state.storage.StateStorage;
import org.neo4j.causalclustering.handlers.PipelineHandlerAppender;
import org.neo4j.causalclustering.helper.ExponentialBackoffStrategy;
import org.neo4j.causalclustering.messaging.LifecycleMessageHandler;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.time.Clocks;

public class CoreServerModule {
    public static final String CLUSTER_ID_NAME = "cluster-id";
    public static final String LAST_FLUSHED_NAME = "last-flushed";
    public final MembershipWaiterLifecycle membershipWaiterLifecycle;
    private final CatchupServer catchupServer;
    private final IdentityModule identityModule;
    private final CoreStateMachinesModule coreStateMachinesModule;
    private final ConsensusModule consensusModule;
    private final ClusteringModule clusteringModule;
    private final LocalDatabase localDatabase;
    private final Supplier<DatabaseHealth> dbHealthSupplier;
    private final CommandApplicationProcess commandApplicationProcess;
    private final CoreSnapshotService snapshotService;
    private final CoreStateDownloaderService downloadService;
    private final Config config;
    private final JobScheduler jobScheduler;
    private final LogProvider logProvider;
    private final PlatformModule platformModule;
    private final PipelineHandlerAppender pipelineAppender;

    public CoreServerModule(IdentityModule identityModule, PlatformModule platformModule, ConsensusModule consensusModule, CoreStateMachinesModule coreStateMachinesModule, ClusteringModule clusteringModule, ReplicationModule replicationModule, LocalDatabase localDatabase, Supplier<DatabaseHealth> dbHealthSupplier, File clusterStateDirectory, PipelineHandlerAppender pipelineAppender) {
        this.identityModule = identityModule;
        this.coreStateMachinesModule = coreStateMachinesModule;
        this.consensusModule = consensusModule;
        this.clusteringModule = clusteringModule;
        this.localDatabase = localDatabase;
        this.dbHealthSupplier = dbHealthSupplier;
        this.platformModule = platformModule;
        this.pipelineAppender = pipelineAppender;
        this.config = platformModule.config;
        this.jobScheduler = platformModule.jobScheduler;
        Dependencies dependencies = platformModule.dependencies;
        LogService logging = platformModule.logging;
        FileSystemAbstraction fileSystem = platformModule.fileSystem;
        LifeSupport life = platformModule.life;
        Map<String, String> overrideBackupSettings = CoreServerModule.backupDisabledSettings();
        this.config.augment(overrideBackupSettings);
        this.logProvider = logging.getInternalLogProvider();
        LogProvider userLogProvider = logging.getUserLogProvider();
        LifeSupport servicesToStopOnStoreCopy = new LifeSupport();
        StateStorage lastFlushedStorage = (StateStorage)platformModule.life.add(new DurableStateStorage<Long>(platformModule.fileSystem, clusterStateDirectory, LAST_FLUSHED_NAME, new LongIndexMarshal(), (Integer)platformModule.config.get(CausalClusteringSettings.last_flushed_state_size), this.logProvider));
        consensusModule.raftMembershipManager().setRecoverFromIndexSupplier(lastFlushedStorage::getInitialState);
        CoreState coreState = new CoreState(coreStateMachinesModule.coreStateMachines, replicationModule.getSessionTracker(), lastFlushedStorage);
        Supplier databaseHealthSupplier = platformModule.dependencies.provideDependency(DatabaseHealth.class);
        this.commandApplicationProcess = new CommandApplicationProcess(consensusModule.raftLog(), (Integer)platformModule.config.get(CausalClusteringSettings.state_machine_apply_max_batch_size), (Integer)platformModule.config.get(CausalClusteringSettings.state_machine_flush_window_size), databaseHealthSupplier, this.logProvider, replicationModule.getProgressTracker(), replicationModule.getSessionTracker(), coreState, consensusModule.inFlightCache(), platformModule.monitors);
        platformModule.dependencies.satisfyDependency((Object)this.commandApplicationProcess);
        this.snapshotService = new CoreSnapshotService(this.commandApplicationProcess, coreState, consensusModule.raftLog(), consensusModule.raftMachine());
        CoreStateDownloader downloader = this.createCoreStateDownloader(servicesToStopOnStoreCopy);
        this.downloadService = new CoreStateDownloaderService(platformModule.jobScheduler, downloader, this.commandApplicationProcess, this.logProvider, new ExponentialBackoffStrategy(1L, 30L, TimeUnit.SECONDS).newTimeout());
        this.membershipWaiterLifecycle = this.createMembershipWaiterLifecycle();
        this.catchupServer = new CatchupServer(this.logProvider, userLogProvider, localDatabase::storeId, platformModule.dependencies.provideDependency(TransactionIdStore.class), platformModule.dependencies.provideDependency(LogicalTransactionStore.class), localDatabase::dataSource, localDatabase::isAvailable, this.snapshotService, this.config, platformModule.monitors, new CheckpointerSupplier(platformModule.dependencies), fileSystem, platformModule.pageCache, platformModule.storeCopyCheckPointMutex, pipelineAppender);
        RaftLogPruner raftLogPruner = new RaftLogPruner(consensusModule.raftMachine(), this.commandApplicationProcess, (Clock)platformModule.clock);
        dependencies.satisfyDependency((Object)raftLogPruner);
        life.add((Lifecycle)new PruningScheduler(raftLogPruner, this.jobScheduler, ((Duration)this.config.get(CausalClusteringSettings.raft_log_pruning_frequency)).toMillis(), this.logProvider));
        dependencies.satisfyDependency((Object)this.catchupServer);
        servicesToStopOnStoreCopy.add((Lifecycle)this.catchupServer);
    }

    private CoreStateDownloader createCoreStateDownloader(LifeSupport servicesToStopOnStoreCopy) {
        long inactivityTimeoutMillis = ((Duration)this.platformModule.config.get(CausalClusteringSettings.catch_up_client_inactivity_timeout)).toMillis();
        CatchUpClient catchUpClient = (CatchUpClient)this.platformModule.life.add((Lifecycle)new CatchUpClient(this.logProvider, Clocks.systemClock(), inactivityTimeoutMillis, this.platformModule.monitors, this.pipelineAppender));
        RemoteStore remoteStore = new RemoteStore(this.logProvider, this.platformModule.fileSystem, this.platformModule.pageCache, new StoreCopyClient(catchUpClient, this.logProvider), new TxPullClient(catchUpClient, this.platformModule.monitors), new TransactionLogCatchUpFactory(), this.config, this.platformModule.monitors);
        CopiedStoreRecovery copiedStoreRecovery = (CopiedStoreRecovery)this.platformModule.life.add((Lifecycle)new CopiedStoreRecovery(this.platformModule.config, this.platformModule.kernelExtensions.listFactories(), this.platformModule.pageCache));
        StoreCopyProcess storeCopyProcess = new StoreCopyProcess(this.platformModule.fileSystem, this.platformModule.pageCache, this.localDatabase, copiedStoreRecovery, remoteStore, this.logProvider);
        return new CoreStateDownloader(this.localDatabase, (Lifecycle)servicesToStopOnStoreCopy, remoteStore, catchUpClient, this.logProvider, storeCopyProcess, this.coreStateMachinesModule.coreStateMachines, this.snapshotService, this.clusteringModule.topologyService());
    }

    private MembershipWaiterLifecycle createMembershipWaiterLifecycle() {
        long electionTimeout = ((Duration)this.config.get(CausalClusteringSettings.leader_election_timeout)).toMillis();
        MembershipWaiter membershipWaiter = new MembershipWaiter(this.identityModule.myself(), this.jobScheduler, this.dbHealthSupplier, electionTimeout * 4L, this.logProvider);
        long joinCatchupTimeout = ((Duration)this.config.get(CausalClusteringSettings.join_catch_up_timeout)).toMillis();
        return new MembershipWaiterLifecycle(membershipWaiter, joinCatchupTimeout, this.consensusModule.raftMachine(), this.logProvider);
    }

    public CatchupServer catchupServer() {
        return this.catchupServer;
    }

    public CoreLife createCoreLife(LifecycleMessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage> handler) {
        return new CoreLife(this.consensusModule.raftMachine(), this.localDatabase, this.clusteringModule.clusterBinder(), this.commandApplicationProcess, this.coreStateMachinesModule.coreStateMachines, handler, this.snapshotService);
    }

    public CommandApplicationProcess commandApplicationProcess() {
        return this.commandApplicationProcess;
    }

    public CoreStateDownloaderService downloadService() {
        return this.downloadService;
    }

    private static Map<String, String> backupDisabledSettings() {
        HashMap<String, String> overrideBackupSettings = new HashMap<String, String>();
        overrideBackupSettings.put(OnlineBackupSettings.online_backup_enabled.name(), "false");
        return overrideBackupSettings;
    }
}

