/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.roles;

import java.io.IOException;
import org.neo4j.causalclustering.core.consensus.MajorityIncludingSelfQuorum;
import org.neo4j.causalclustering.core.consensus.RaftMessageHandler;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.roles.Appending;
import org.neo4j.causalclustering.core.consensus.roles.Election;
import org.neo4j.causalclustering.core.consensus.roles.Heart;
import org.neo4j.causalclustering.core.consensus.roles.Pruning;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.consensus.roles.Voting;
import org.neo4j.causalclustering.core.consensus.state.ReadableRaftState;
import org.neo4j.logging.Log;

class Follower
implements RaftMessageHandler {
    Follower() {
    }

    static boolean logHistoryMatches(ReadableRaftState ctx, long leaderSegmentPrevIndex, long leaderSegmentPrevTerm) throws IOException {
        long localLogPrevIndex = ctx.entryLog().prevIndex();
        long localSegmentPrevTerm = ctx.entryLog().readEntryTerm(leaderSegmentPrevIndex);
        return leaderSegmentPrevIndex > -1L && (leaderSegmentPrevIndex <= localLogPrevIndex || localSegmentPrevTerm == leaderSegmentPrevTerm);
    }

    static void commitToLogOnUpdate(ReadableRaftState ctx, long indexOfLastNewEntry, long leaderCommit, Outcome outcome) {
        long newCommitIndex = Long.min(leaderCommit, indexOfLastNewEntry);
        if (newCommitIndex > ctx.commitIndex()) {
            outcome.setCommitIndex(newCommitIndex);
        }
    }

    private static void handleLeaderLogCompaction(ReadableRaftState ctx, Outcome outcome, RaftMessages.LogCompactionInfo compactionInfo) {
        if (compactionInfo.leaderTerm() < ctx.term()) {
            return;
        }
        if (ctx.entryLog().appendIndex() <= -1L || compactionInfo.prevIndex() > ctx.entryLog().appendIndex()) {
            outcome.markNeedForFreshSnapshot();
        }
    }

    @Override
    public Outcome handle(RaftMessages.RaftMessage message, ReadableRaftState ctx, Log log) throws IOException {
        return message.dispatch(this.visitor(ctx, log));
    }

    private Handler visitor(ReadableRaftState ctx, Log log) {
        if (ctx.supportPreVoting()) {
            if (ctx.isPreElection()) {
                return new PreVoteActiveHandler(ctx, log);
            }
            return new PreVoteInactiveHandler(ctx, log);
        }
        return new PreVoteUnsupportedHandler(ctx, log);
    }

    class PreVoteUnsupportedHandler
    extends Handler {
        PreVoteUnsupportedHandler(ReadableRaftState ctx, Log log) {
            super(ctx, log);
        }

        @Override
        public Outcome handle(RaftMessages.Timeout.Election election) throws IOException {
            this.log.info("Election timeout triggered");
            if (Election.startRealElection(this.ctx, this.outcome, this.log)) {
                this.outcome.setNextRole(Role.CANDIDATE);
                this.log.info("Moving to CANDIDATE state after successfully starting election");
            }
            return this.outcome;
        }

        @Override
        public Outcome handle(RaftMessages.PreVote.Response response) throws IOException {
            return this.outcome;
        }

        @Override
        public Outcome handle(RaftMessages.PreVote.Request request) throws IOException {
            return this.outcome;
        }
    }

    class PreVoteInactiveHandler
    extends PreVoteSupportedHandler {
        PreVoteInactiveHandler(ReadableRaftState ctx, Log log) {
            super(ctx, log);
        }

        @Override
        public Outcome handle(RaftMessages.PreVote.Response response) throws IOException {
            return this.outcome;
        }

        @Override
        public Outcome handle(RaftMessages.PreVote.Request request) throws IOException {
            this.outcome.addOutgoingMessage(new RaftMessages.Directed(request.from(), new RaftMessages.PreVote.Response(this.ctx.myself(), this.outcome.getTerm(), false)));
            return this.outcome;
        }
    }

    class PreVoteActiveHandler
    extends PreVoteSupportedHandler {
        PreVoteActiveHandler(ReadableRaftState ctx, Log log) {
            super(ctx, log);
        }

        @Override
        public Outcome handle(RaftMessages.PreVote.Request request) throws IOException {
            Voting.handlePreVoteRequest(this.ctx, this.outcome, request, this.log);
            return this.outcome;
        }

        @Override
        public Outcome handle(RaftMessages.PreVote.Response res) throws IOException {
            if (res.term() > this.ctx.term()) {
                this.outcome.setNextTerm(res.term());
                this.log.info("Aborting pre-election after receiving pre-vote response from %s at term %d (I am at %d)", new Object[]{res.from(), res.term(), this.ctx.term()});
                return this.outcome;
            }
            if (res.term() < this.ctx.term() || !res.voteGranted()) {
                return this.outcome;
            }
            if (!res.from().equals(this.ctx.myself())) {
                this.outcome.addPreVoteForMe(res.from());
            }
            if (MajorityIncludingSelfQuorum.isQuorum(this.ctx.votingMembers(), this.outcome.getPreVotesForMe())) {
                this.outcome.renewElectionTimeout();
                this.outcome.setPreElection(false);
                if (Election.startRealElection(this.ctx, this.outcome, this.log)) {
                    this.outcome.setNextRole(Role.CANDIDATE);
                    this.log.info("Moving to CANDIDATE state after successful pre-election stage");
                }
            }
            return this.outcome;
        }
    }

    abstract class PreVoteSupportedHandler
    extends Handler {
        PreVoteSupportedHandler(ReadableRaftState ctx, Log log) {
            super(ctx, log);
        }

        @Override
        public Outcome handle(RaftMessages.Timeout.Election election) throws IOException {
            this.log.info("Election timeout triggered");
            if (Election.startPreElection(this.ctx, this.outcome, this.log)) {
                this.outcome.setPreElection(true);
            }
            return this.outcome;
        }
    }

    private static abstract class Handler
    implements RaftMessages.Handler<Outcome, IOException> {
        protected final ReadableRaftState ctx;
        protected final Log log;
        protected final Outcome outcome;

        Handler(ReadableRaftState ctx, Log log) {
            this.ctx = ctx;
            this.log = log;
            this.outcome = new Outcome(Role.FOLLOWER, ctx);
        }

        @Override
        public Outcome handle(RaftMessages.Heartbeat heartbeat) throws IOException {
            Heart.beat(this.ctx, this.outcome, heartbeat, this.log);
            return this.outcome;
        }

        @Override
        public Outcome handle(RaftMessages.AppendEntries.Request request) throws IOException {
            Appending.handleAppendEntriesRequest(this.ctx, this.outcome, request, this.log);
            return this.outcome;
        }

        @Override
        public Outcome handle(RaftMessages.Vote.Request request) throws IOException {
            Voting.handleVoteRequest(this.ctx, this.outcome, request, this.log);
            return this.outcome;
        }

        @Override
        public Outcome handle(RaftMessages.LogCompactionInfo logCompactionInfo) throws IOException {
            Follower.handleLeaderLogCompaction(this.ctx, this.outcome, logCompactionInfo);
            return this.outcome;
        }

        @Override
        public Outcome handle(RaftMessages.Vote.Response response) throws IOException {
            this.log.info("Late vote response: %s", new Object[]{response});
            return this.outcome;
        }

        @Override
        public Outcome handle(RaftMessages.PruneRequest pruneRequest) throws IOException {
            Pruning.handlePruneRequest(this.outcome, pruneRequest);
            return this.outcome;
        }

        @Override
        public Outcome handle(RaftMessages.AppendEntries.Response response) throws IOException {
            return this.outcome;
        }

        @Override
        public Outcome handle(RaftMessages.HeartbeatResponse heartbeatResponse) throws IOException {
            return this.outcome;
        }

        @Override
        public Outcome handle(RaftMessages.Timeout.Heartbeat heartbeat) throws IOException {
            return this.outcome;
        }

        @Override
        public Outcome handle(RaftMessages.NewEntry.Request request) throws IOException {
            return this.outcome;
        }

        @Override
        public Outcome handle(RaftMessages.NewEntry.BatchRequest batchRequest) throws IOException {
            return this.outcome;
        }
    }
}

