/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.outcome;

import java.io.IOException;
import java.util.Objects;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.cache.InFlightCache;
import org.neo4j.causalclustering.core.consensus.outcome.RaftLogCommand;
import org.neo4j.logging.Log;

public class AppendLogEntry
implements RaftLogCommand {
    public final long index;
    public final RaftLogEntry entry;

    public AppendLogEntry(long index, RaftLogEntry entry) {
        this.index = index;
        this.entry = entry;
    }

    @Override
    public void applyTo(RaftLog raftLog, Log log) throws IOException {
        if (this.index <= raftLog.appendIndex()) {
            throw new IllegalStateException("Attempted to append over an existing entry at index " + this.index);
        }
        raftLog.append(this.entry);
    }

    @Override
    public void applyTo(InFlightCache inFlightCache, Log log) throws IOException {
        inFlightCache.put(this.index, this.entry);
    }

    @Override
    public void dispatch(RaftLogCommand.Handler handler) throws IOException {
        handler.append(this.index, this.entry);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppendLogEntry that = (AppendLogEntry)o;
        return this.index == that.index && Objects.equals(this.entry, that.entry);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.entry);
    }

    public String toString() {
        return "AppendLogEntry{index=" + this.index + ", entry=" + this.entry + '}';
    }
}

