/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.cache;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.cache.InFlightCache;

public class UnboundedInFlightCache
implements InFlightCache {
    private Map<Long, RaftLogEntry> map = new HashMap<Long, RaftLogEntry>();
    private boolean enabled;

    @Override
    public synchronized void enable() {
        this.enabled = true;
    }

    @Override
    public synchronized void put(long logIndex, RaftLogEntry entry) {
        if (!this.enabled) {
            return;
        }
        this.map.put(logIndex, entry);
    }

    @Override
    public synchronized RaftLogEntry get(long logIndex) {
        if (!this.enabled) {
            return null;
        }
        return this.map.get(logIndex);
    }

    @Override
    public synchronized void truncate(long fromIndex) {
        if (!this.enabled) {
            return;
        }
        this.map.keySet().removeIf(idx -> idx >= fromIndex);
    }

    @Override
    public synchronized void prune(long upToIndex) {
        if (!this.enabled) {
            return;
        }
        this.map.keySet().removeIf(idx -> idx <= upToIndex);
    }

    @Override
    public synchronized long totalBytes() {
        return 0L;
    }

    @Override
    public synchronized int elementCount() {
        return 0;
    }
}

