/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus;

import java.util.concurrent.ThreadFactory;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class ContinuousJob
extends LifecycleAdapter {
    private final AbortableJob abortableJob;
    private final Log log;
    private final Thread thread;

    public ContinuousJob(ThreadFactory threadFactory, Runnable task, LogProvider logProvider) {
        this.abortableJob = new AbortableJob(task);
        this.thread = threadFactory.newThread(this.abortableJob);
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
    }

    public void start() throws Throwable {
        this.abortableJob.keepRunning = true;
        this.thread.start();
    }

    public void stop() throws Throwable {
        this.log.info("ContinuousJob " + this.thread.getName() + " stopping");
        this.abortableJob.keepRunning = false;
        this.thread.join();
    }

    private static class AbortableJob
    implements Runnable {
        private final Runnable task;
        private volatile boolean keepRunning;

        AbortableJob(Runnable task) {
            this.task = task;
        }

        @Override
        public void run() {
            while (this.keepRunning) {
                this.task.run();
            }
        }
    }
}

