/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import java.time.Clock;
import java.util.function.Function;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.core.BatchingMessageHandler;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.ClusterBindingHandler;
import org.neo4j.causalclustering.core.IdentityModule;
import org.neo4j.causalclustering.core.consensus.ConsensusModule;
import org.neo4j.causalclustering.core.consensus.ContinuousJob;
import org.neo4j.causalclustering.core.consensus.LeaderAvailabilityHandler;
import org.neo4j.causalclustering.core.consensus.RaftMessageMonitoringHandler;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.RaftServer;
import org.neo4j.causalclustering.core.server.CoreServerModule;
import org.neo4j.causalclustering.core.state.RaftMessageApplier;
import org.neo4j.causalclustering.handlers.PipelineHandlerAppender;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.logging.MessageLogger;
import org.neo4j.causalclustering.messaging.ComposableMessageHandler;
import org.neo4j.causalclustering.messaging.CoreReplicatedContentMarshal;
import org.neo4j.causalclustering.messaging.LifecycleMessageHandler;
import org.neo4j.causalclustering.messaging.LoggingInbound;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;

public class RaftServerModule {
    private final PlatformModule platformModule;
    private final ConsensusModule consensusModule;
    private final IdentityModule identityModule;
    private final LocalDatabase localDatabase;
    private final Monitors monitors;
    private final MessageLogger<MemberId> messageLogger;
    private final LogProvider logProvider;
    private final PipelineHandlerAppender pipelineHandlerAppender;

    RaftServerModule(PlatformModule platformModule, ConsensusModule consensusModule, IdentityModule identityModule, CoreServerModule coreServerModule, LocalDatabase localDatabase, PipelineHandlerAppender pipelineHandlerAppender, Monitors monitors, MessageLogger<MemberId> messageLogger) {
        this.platformModule = platformModule;
        this.consensusModule = consensusModule;
        this.identityModule = identityModule;
        this.localDatabase = localDatabase;
        this.monitors = monitors;
        this.messageLogger = messageLogger;
        this.logProvider = platformModule.logging.getInternalLogProvider();
        this.pipelineHandlerAppender = pipelineHandlerAppender;
        LifecycleMessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage> messageHandlerChain = this.createMessageHandlerChain(coreServerModule);
        this.createRaftServer(coreServerModule, messageHandlerChain);
    }

    private void createRaftServer(CoreServerModule coreServerModule, LifecycleMessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage> messageHandlerChain) {
        RaftServer raftServer = new RaftServer(new CoreReplicatedContentMarshal(), this.pipelineHandlerAppender, this.platformModule.config, this.logProvider, this.platformModule.logging.getUserLogProvider(), this.monitors, (Clock)this.platformModule.clock);
        LoggingInbound<RaftMessages.ReceivedInstantClusterIdAwareMessage> loggingRaftInbound = new LoggingInbound<RaftMessages.ReceivedInstantClusterIdAwareMessage>(raftServer, this.messageLogger, this.identityModule.myself());
        loggingRaftInbound.registerHandler(messageHandlerChain);
        this.platformModule.life.add((Lifecycle)raftServer);
        this.platformModule.life.add((Lifecycle)coreServerModule.createCoreLife(messageHandlerChain));
        this.platformModule.life.add((Lifecycle)coreServerModule.catchupServer());
        this.platformModule.life.add((Lifecycle)coreServerModule.downloadService());
    }

    private LifecycleMessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage> createMessageHandlerChain(CoreServerModule coreServerModule) {
        RaftMessageApplier messageApplier = new RaftMessageApplier(this.localDatabase, this.logProvider, this.consensusModule.raftMachine(), coreServerModule.downloadService(), coreServerModule.commandApplicationProcess());
        ComposableMessageHandler monitoringHandler = RaftMessageMonitoringHandler.composable((Clock)this.platformModule.clock, this.platformModule.monitors);
        int queueSize = (Integer)this.platformModule.config.get(CausalClusteringSettings.raft_in_queue_size);
        int maxBatch = (Integer)this.platformModule.config.get(CausalClusteringSettings.raft_in_queue_max_batch);
        Function<Runnable, ContinuousJob> jobFactory = runnable -> new ContinuousJob(this.platformModule.jobScheduler.threadFactory(new JobScheduler.Group("raft-batch-handler")), (Runnable)runnable, this.logProvider);
        ComposableMessageHandler batchingMessageHandler = BatchingMessageHandler.composable(queueSize, maxBatch, jobFactory, this.logProvider);
        ComposableMessageHandler leaderAvailabilityHandler = LeaderAvailabilityHandler.composable(this.consensusModule.getLeaderAvailabilityTimers(), this.consensusModule.raftMachine()::term);
        ComposableMessageHandler clusterBindingHandler = ClusterBindingHandler.composable(this.logProvider);
        return (LifecycleMessageHandler)clusterBindingHandler.compose(leaderAvailabilityHandler).compose(batchingMessageHandler).compose(monitoringHandler).apply(messageApplier);
    }
}

