/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import java.io.File;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import org.neo4j.causalclustering.core.consensus.log.cache.InFlightCacheFactory;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.graphdb.config.BaseSetting;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.kernel.configuration.Settings;

@Description(value="Settings for Causal Clustering")
public class CausalClusteringSettings
implements LoadableConfig {
    @Description(value="Time out for a new member to catch up")
    public static final Setting<Duration> join_catch_up_timeout = Settings.setting((String)"causal_clustering.join_catch_up_timeout", (Function)Settings.DURATION, (String)"10m");
    @Description(value="The time limit within which a new leader election will occur if no messages are received.")
    public static final Setting<Duration> leader_election_timeout = Settings.setting((String)"causal_clustering.leader_election_timeout", (Function)Settings.DURATION, (String)"7s");
    @Description(value="Prevents the current instance from volunteering to become Raft leader. Defaults to false, and should only be used in exceptional circumstances by expert users. Using this can result in reduced availability for the cluster.")
    public static final Setting<Boolean> refuse_to_be_leader = Settings.setting((String)"causal_clustering.refuse_to_be_leader", (Function)Settings.BOOLEAN, (String)"false");
    @Description(value="Enable pre-voting extension to the Raft protocol (this is breaking and must match between the core cluster members)")
    public static final Setting<Boolean> enable_pre_voting = Settings.setting((String)"causal_clustering.enable_pre_voting", (Function)Settings.BOOLEAN, (String)"false");
    @Description(value="The maximum batch size when catching up (in unit of entries)")
    public static final Setting<Integer> catchup_batch_size = Settings.setting((String)"causal_clustering.catchup_batch_size", (Function)Settings.INTEGER, (String)"64");
    @Description(value="The maximum lag allowed before log shipping pauses (in unit of entries)")
    public static final Setting<Integer> log_shipping_max_lag = Settings.setting((String)"causal_clustering.log_shipping_max_lag", (Function)Settings.INTEGER, (String)"256");
    @Description(value="Size of the RAFT in queue")
    @Internal
    public static final Setting<Integer> raft_in_queue_size = Settings.setting((String)"causal_clustering.raft_in_queue_size", (Function)Settings.INTEGER, (String)"64");
    @Description(value="Largest batch processed by RAFT")
    @Internal
    public static final Setting<Integer> raft_in_queue_max_batch = Settings.setting((String)"causal_clustering.raft_in_queue_max_batch", (Function)Settings.INTEGER, (String)"64");
    @Description(value="Expected number of Core machines in the cluster")
    public static final Setting<Integer> expected_core_cluster_size = Settings.setting((String)"causal_clustering.expected_core_cluster_size", (Function)Settings.INTEGER, (String)"3");
    @Description(value="Network interface and port for the transaction shipping server to listen on.")
    public static final Setting<ListenSocketAddress> transaction_listen_address = Settings.listenAddress((String)"causal_clustering.transaction_listen_address", (int)6000);
    @Description(value="Advertised hostname/IP address and port for the transaction shipping server.")
    public static final Setting<AdvertisedSocketAddress> transaction_advertised_address = Settings.advertisedAddress((String)"causal_clustering.transaction_advertised_address", transaction_listen_address);
    @Description(value="Network interface and port for the RAFT server to listen on.")
    public static final Setting<ListenSocketAddress> raft_listen_address = Settings.listenAddress((String)"causal_clustering.raft_listen_address", (int)7000);
    @Description(value="Advertised hostname/IP address and port for the RAFT server.")
    public static final Setting<AdvertisedSocketAddress> raft_advertised_address = Settings.advertisedAddress((String)"causal_clustering.raft_advertised_address", raft_listen_address);
    @Description(value="Host and port to bind the cluster member discovery management communication.")
    public static final Setting<ListenSocketAddress> discovery_listen_address = Settings.listenAddress((String)"causal_clustering.discovery_listen_address", (int)5000);
    @Description(value="Advertised cluster member discovery management communication.")
    public static final Setting<AdvertisedSocketAddress> discovery_advertised_address = Settings.advertisedAddress((String)"causal_clustering.discovery_advertised_address", discovery_listen_address);
    @Description(value="A comma-separated list of other members of the cluster to join.")
    public static final Setting<List<AdvertisedSocketAddress>> initial_discovery_members = Settings.setting((String)"causal_clustering.initial_discovery_members", (Function)Settings.list((String)",", (Function)Settings.ADVERTISED_SOCKET_ADDRESS), (String)Settings.NO_DEFAULT);
    @Description(value="Type of in-flight cache.")
    public static final Setting<InFlightCacheFactory.Type> in_flight_cache_type = Settings.setting((String)"causal_clustering.in_flight_cache.type", (Function)Settings.options(InFlightCacheFactory.Type.class, (boolean)true), (String)InFlightCacheFactory.Type.CONSECUTIVE.name());
    @Description(value="The maximum number of entries in the in-flight cache.")
    public static final Setting<Integer> in_flight_cache_max_entries = Settings.setting((String)"causal_clustering.in_flight_cache.max_entries", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The maximum number of bytes in the in-flight cache.")
    public static final Setting<Long> in_flight_cache_max_bytes = Settings.setting((String)"causal_clustering.in_flight_cache.max_bytes", (Function)Settings.BYTES, (String)"2G");
    @Description(value="Configure the discovery type used for cluster name resolution")
    public static final Setting<DiscoveryType> discovery_type = Settings.setting((String)"causal_clustering.discovery_type", (Function)Settings.options(DiscoveryType.class), (String)DiscoveryType.LIST.name());
    @Description(value="Prevents the network middleware from dumping its own logs. Defaults to true.")
    public static final Setting<Boolean> disable_middleware_logging = Settings.setting((String)"causal_clustering.disable_middleware_logging", (Function)Settings.BOOLEAN, (String)"true");
    @Description(value="The level of middleware logging")
    public static final Setting<Integer> middleware_logging_level = Settings.setting((String)"causal_clustering.middleware_logging.level", (Function)Settings.INTEGER, (String)Integer.toString(Level.FINE.intValue()));
    @Internal
    @Description(value="Hazelcast license key")
    public static final Setting<String> hazelcast_license_key = Settings.setting((String)"hazelcast.license_key", (Function)Settings.STRING, (String)Settings.NO_DEFAULT);
    @Description(value="The maximum file size before the storage file is rotated (in unit of entries)")
    public static final Setting<Integer> last_flushed_state_size = Settings.setting((String)"causal_clustering.last_applied_state_size", (Function)Settings.INTEGER, (String)"1000");
    @Description(value="The maximum file size before the ID allocation file is rotated (in unit of entries)")
    public static final Setting<Integer> id_alloc_state_size = Settings.setting((String)"causal_clustering.id_alloc_state_size", (Function)Settings.INTEGER, (String)"1000");
    @Description(value="The maximum file size before the membership state file is rotated (in unit of entries)")
    public static final Setting<Integer> raft_membership_state_size = Settings.setting((String)"causal_clustering.raft_membership_state_size", (Function)Settings.INTEGER, (String)"1000");
    @Description(value="The maximum file size before the vote state file is rotated (in unit of entries)")
    public static final Setting<Integer> vote_state_size = Settings.setting((String)"causal_clustering.raft_vote_state_size", (Function)Settings.INTEGER, (String)"1000");
    @Description(value="The maximum file size before the term state file is rotated (in unit of entries)")
    public static final Setting<Integer> term_state_size = Settings.setting((String)"causal_clustering.raft_term_state_size", (Function)Settings.INTEGER, (String)"1000");
    @Description(value="The maximum file size before the global session tracker state file is rotated (in unit of entries)")
    public static final Setting<Integer> global_session_tracker_state_size = Settings.setting((String)"causal_clustering.global_session_tracker_state_size", (Function)Settings.INTEGER, (String)"1000");
    @Description(value="The maximum file size before the replicated lock token state file is rotated (in unit of entries)")
    public static final Setting<Integer> replicated_lock_token_state_size = Settings.setting((String)"causal_clustering.replicated_lock_token_state_size", (Function)Settings.INTEGER, (String)"1000");
    @Description(value="The maximum amount of data which can be in the replication stage concurrently.")
    public static final Setting<Long> replication_total_size_limit = Settings.setting((String)"causal_clustering.replication_total_size_limit", (Function)Settings.BYTES, (String)"128M");
    @Description(value="The initial timeout until replication is retried. The timeout will increase exponentially.")
    public static final Setting<Duration> replication_retry_timeout_base = Settings.setting((String)"causal_clustering.replication_retry_timeout_base", (Function)Settings.DURATION, (String)"10s");
    @Description(value="The upper limit for the exponentially incremented retry timeout.")
    public static final Setting<Duration> replication_retry_timeout_limit = Settings.setting((String)"causal_clustering.replication_retry_timeout_limit", (Function)Settings.DURATION, (String)"60s");
    @Description(value="The retry timeout for finding a leader for replication. Relevant during leader elections.")
    public static final Setting<Duration> replication_leader_retry_timeout = Settings.setting((String)"causal_clustering.replication_leader", (Function)Settings.DURATION, (String)"500ms");
    @Description(value="The number of operations to be processed before the state machines flush to disk")
    public static final Setting<Integer> state_machine_flush_window_size = Settings.setting((String)"causal_clustering.state_machine_flush_window_size", (Function)Settings.INTEGER, (String)"4096");
    @Description(value="The maximum number of operations to be batched during applications of operations in the state machines")
    public static final Setting<Integer> state_machine_apply_max_batch_size = Settings.setting((String)"causal_clustering.state_machine_apply_max_batch_size", (Function)Settings.INTEGER, (String)"16");
    @Description(value="RAFT log pruning strategy")
    public static final Setting<String> raft_log_pruning_strategy = Settings.setting((String)"causal_clustering.raft_log_prune_strategy", (Function)Settings.STRING, (String)"1g size");
    @Description(value="RAFT log implementation")
    public static final Setting<String> raft_log_implementation = Settings.setting((String)"causal_clustering.raft_log_implementation", (Function)Settings.STRING, (String)"SEGMENTED");
    @Description(value="RAFT log rotation size")
    public static final Setting<Long> raft_log_rotation_size = Settings.buildSetting((String)"causal_clustering.raft_log_rotation_size", (Function)Settings.BYTES, (String)"250M").constraint(Settings.min((Comparable)Long.valueOf(1024L))).build();
    @Description(value="RAFT log reader pool size")
    public static final Setting<Integer> raft_log_reader_pool_size = Settings.setting((String)"causal_clustering.raft_log_reader_pool_size", (Function)Settings.INTEGER, (String)"8");
    @Description(value="RAFT log pruning frequency")
    public static final Setting<Duration> raft_log_pruning_frequency = Settings.setting((String)"causal_clustering.raft_log_pruning_frequency", (Function)Settings.DURATION, (String)"10m");
    @Description(value="Enable or disable the dump of all network messages pertaining to the RAFT protocol")
    @Internal
    public static final Setting<Boolean> raft_messages_log_enable = Settings.setting((String)"causal_clustering.raft_messages_log_enable", (Function)Settings.BOOLEAN, (String)"false");
    @Description(value="Path to RAFT messages log.")
    @Internal
    public static final Setting<File> raft_messages_log_path = Settings.derivedSetting((String)"causal_clustering.raft_messages_log_path", (Setting)GraphDatabaseSettings.logs_directory, logs -> new File((File)logs, "raft-messages.log"), (Function)Settings.PATH);
    @Description(value="Interval of pulling updates from cores.")
    public static final Setting<Duration> pull_interval = Settings.setting((String)"causal_clustering.pull_interval", (Function)Settings.DURATION, (String)"1s");
    @Description(value="The catch up protocol times out if the given duration elapses with no network activity. Every message received by the client from the server extends the time out duration.")
    public static final Setting<Duration> catch_up_client_inactivity_timeout = Settings.setting((String)"causal_clustering.catch_up_client_inactivity_timeout", (Function)Settings.DURATION, (String)"20s");
    @Description(value="Throttle limit for logging unknown cluster member address")
    public static final Setting<Duration> unknown_address_logging_throttle = Settings.setting((String)"causal_clustering.unknown_address_logging_throttle", (Function)Settings.DURATION, (String)"10000ms");
    @Description(value="Maximum transaction batch size for read replicas when applying transactions pulled from core servers.")
    @Internal
    public static Setting<Integer> read_replica_transaction_applier_batch_size = Settings.setting((String)"causal_clustering.read_replica_transaction_applier_batch_size", (Function)Settings.INTEGER, (String)"64");
    @Description(value="Time To Live before read replica is considered unavailable")
    public static final Setting<Duration> read_replica_time_to_live = Settings.buildSetting((String)"causal_clustering.read_replica_time_to_live", (Function)Settings.DURATION, (String)"1m").constraint(Settings.min((Comparable)Duration.ofSeconds(60L))).build();
    @Description(value="How long drivers should cache the data from the `dbms.cluster.routing.getServers()` procedure.")
    public static final Setting<Duration> cluster_routing_ttl = Settings.buildSetting((String)"causal_clustering.cluster_routing_ttl", (Function)Settings.DURATION, (String)"300s").constraint(Settings.min((Comparable)Duration.ofSeconds(1L))).build();
    @Description(value="Configure if the `dbms.cluster.routing.getServers()` procedure should include followers as read endpoints or return only read replicas. Note: if there are no read replicas in the cluster, followers are returned as read end points regardless the value of this setting. Defaults to true so that followersare available for read-only queries in a typical heterogeneous setup.")
    public static final Setting<Boolean> cluster_allow_reads_on_followers = Settings.setting((String)"causal_clustering.cluster_allow_reads_on_followers", (Function)Settings.BOOLEAN, (String)"true");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of NODE IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> node_id_allocation_size = Settings.setting((String)"causal_clustering.node_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of RELATIONSHIP IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> relationship_id_allocation_size = Settings.setting((String)"causal_clustering.relationship_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of PROPERTY IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> property_id_allocation_size = Settings.setting((String)"causal_clustering.property_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of STRING_BLOCK IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> string_block_id_allocation_size = Settings.setting((String)"causal_clustering.string_block_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of ARRAY_BLOCK IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> array_block_id_allocation_size = Settings.setting((String)"causal_clustering.array_block_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of PROPERTY_KEY_TOKEN IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> property_key_token_id_allocation_size = Settings.setting((String)"causal_clustering.property_key_token_id_allocation_size", (Function)Settings.INTEGER, (String)"32");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of PROPERTY_KEY_TOKEN_NAME IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> property_key_token_name_id_allocation_size = Settings.setting((String)"causal_clustering.property_key_token_name_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of RELATIONSHIP_TYPE_TOKEN IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> relationship_type_token_id_allocation_size = Settings.setting((String)"causal_clustering.relationship_type_token_id_allocation_size", (Function)Settings.INTEGER, (String)"32");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of RELATIONSHIP_TYPE_TOKEN_NAME IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> relationship_type_token_name_id_allocation_size = Settings.setting((String)"causal_clustering.relationship_type_token_name_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of LABEL_TOKEN IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> label_token_id_allocation_size = Settings.setting((String)"causal_clustering.label_token_id_allocation_size", (Function)Settings.INTEGER, (String)"32");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of LABEL_TOKEN_NAME IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> label_token_name_id_allocation_size = Settings.setting((String)"causal_clustering.label_token_name_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of NEOSTORE_BLOCK IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> neostore_block_id_allocation_size = Settings.setting((String)"causal_clustering.neostore_block_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of SCHEMA IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> schema_id_allocation_size = Settings.setting((String)"causal_clustering.schema_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of NODE_LABELS IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> node_labels_id_allocation_size = Settings.setting((String)"causal_clustering.node_labels_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of RELATIONSHIP_GROUP IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> relationship_group_id_allocation_size = Settings.setting((String)"causal_clustering.relationship_group_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="Time between scanning the cluster to refresh current server's view of topology")
    public static final Setting<Duration> cluster_topology_refresh = Settings.buildSetting((String)"causal_clustering.cluster_topology_refresh", (Function)Settings.DURATION, (String)"5s").constraint(Settings.min((Comparable)Duration.ofSeconds(1L))).build();
    @Description(value="An ordered list in descending preference of the strategy which read replicas use to choose the upstream server from which to pull transactional updates.")
    public static final Setting<List<String>> upstream_selection_strategy = Settings.setting((String)"causal_clustering.upstream_selection_strategy", (Function)Settings.list((String)",", (Function)Settings.STRING), (String)"default");
    @Description(value="Configuration of a user-defined upstream selection strategy. The user-defined strategy is used if the list of strategies (`causal_clustering.upstream_selection_strategy`) includes the value `user_defined`. ")
    public static final Setting<String> user_defined_upstream_selection_strategy = Settings.setting((String)"causal_clustering.user_defined_upstream_strategy", (Function)Settings.STRING, (String)"");
    @Description(value="Comma separated list of groups to be used by the connect-randomly-to-server-group selection strategy. The connect-randomly-to-server-group strategy is used if the list of strategies (`causal_clustering.upstream_selection_strategy`) includes the value `connect-randomly-to-server-group`. ")
    public static final Setting<List<String>> connect_randomly_to_server_group_strategy = Settings.setting((String)"causal_clustering.connect-randomly-to-server-group", (Function)Settings.list((String)",", (Function)Settings.STRING), (String)"");
    @Description(value="A list of group names for the server used when configuring load balancing and replication policies.")
    public static final Setting<List<String>> server_groups = Settings.setting((String)"causal_clustering.server_groups", (Function)Settings.list((String)",", (Function)Settings.STRING), (String)"");
    @Description(value="The load balancing plugin to use.")
    public static final Setting<String> load_balancing_plugin = Settings.setting((String)"causal_clustering.load_balancing.plugin", (Function)Settings.STRING, (String)"server_policies");
    @Description(value="The configuration must be valid for the configured plugin and usually existsunder matching subkeys, e.g. ..config.server_policies.*This is just a top-level placeholder for the plugin-specific configuration.")
    public static final Setting<String> load_balancing_config = CausalClusteringSettings.prefixSetting("causal_clustering.load_balancing.config", Settings.STRING, "");
    @Description(value="Enables shuffling of the returned load balancing result.")
    public static final Setting<Boolean> load_balancing_shuffle = Settings.setting((String)"causal_clustering.load_balancing.shuffle", (Function)Settings.BOOLEAN, (String)"true");
    @Description(value="Require authorization for access to the Causal Clustering status endpoints.")
    public static final Setting<Boolean> status_auth_enabled = Settings.setting((String)"dbms.security.causal_clustering_status_auth_enabled", (Function)Settings.BOOLEAN, (String)"true");
    @Description(value="Enable multi-data center features. Requires appropriate licensing.")
    public static final Setting<Boolean> multi_dc_license = Settings.setting((String)"causal_clustering.multi_dc_license", (Function)Settings.BOOLEAN, (String)"false");
    @Description(value="Name of the SSL policy to be used by the clustering, as defined under the dbms.ssl.policy.* settings. If no policy is configured then the communication will not be secured.")
    public static final Setting<String> ssl_policy = CausalClusteringSettings.prefixSetting("causal_clustering.ssl_policy", Settings.STRING, Settings.NO_DEFAULT);

    static BaseSetting<String> prefixSetting(String name, Function<String, String> parser, String defaultValue) {
        BiFunction<String, Function, String> valueLookup = (n, settings) -> (String)settings.apply(n);
        BiFunction defaultLookup = Settings.determineDefaultLookup((String)defaultValue, valueLookup);
        return new Settings.DefaultSetting<String>(name, parser, valueLookup, defaultLookup, Collections.emptyList()){

            public Map<String, String> validate(Map<String, String> rawConfig, Consumer<String> warningConsumer) throws InvalidSettingException {
                try {
                    this.apply(rawConfig::get);
                    HashMap<String, String> validConfig = new HashMap<String, String>();
                    rawConfig.keySet().stream().filter(key -> key.startsWith(this.name())).forEach(key -> {
                        String cfr_ignored_0 = (String)validConfig.put((String)key, (String)rawConfig.get(key));
                    });
                    return validConfig;
                }
                catch (RuntimeException e) {
                    throw new InvalidSettingException(e.getMessage(), (Throwable)e);
                }
            }
        };
    }

    public static enum DiscoveryType {
        DNS,
        LIST;

    }
}

