/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.load_balancing.LoadBalancingPluginLoader;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationValidator;
import org.neo4j.kernel.impl.enterprise.configuration.EnterpriseEditionSettings;
import org.neo4j.logging.Log;

public class CausalClusterConfigurationValidator
implements ConfigurationValidator {
    public Map<String, String> validate(@Nonnull Config config, @Nonnull Log log) throws InvalidSettingException {
        EnterpriseEditionSettings.Mode mode = (EnterpriseEditionSettings.Mode)config.get(EnterpriseEditionSettings.mode);
        if (mode.equals((Object)EnterpriseEditionSettings.Mode.CORE) || mode.equals((Object)EnterpriseEditionSettings.Mode.READ_REPLICA)) {
            CausalClusterConfigurationValidator.validateInitialDiscoveryMembers(config);
            CausalClusterConfigurationValidator.validateBoltConnector(config);
            CausalClusterConfigurationValidator.validateLoadBalancing(config, log);
        }
        return Collections.emptyMap();
    }

    private static void validateLoadBalancing(Config config, Log log) {
        LoadBalancingPluginLoader.validate(config, log);
    }

    private static void validateBoltConnector(Config config) {
        if (config.enabledBoltConnectors().isEmpty()) {
            throw new InvalidSettingException("A Bolt connector must be configured to run a cluster");
        }
    }

    private static void validateInitialDiscoveryMembers(Config config) {
        if (!config.isConfigured(CausalClusteringSettings.initial_discovery_members)) {
            throw new InvalidSettingException(String.format("Missing mandatory non-empty value for '%s'", CausalClusteringSettings.initial_discovery_members.name()));
        }
    }
}

