/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.tx;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.IOException;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.neo4j.causalclustering.catchup.CatchupResult;
import org.neo4j.causalclustering.catchup.CatchupServerProtocol;
import org.neo4j.causalclustering.catchup.ResponseMessageType;
import org.neo4j.causalclustering.catchup.tx.ChunkedTransactionStream;
import org.neo4j.causalclustering.catchup.tx.TxPullRequest;
import org.neo4j.causalclustering.catchup.tx.TxPullRequestsMonitor;
import org.neo4j.causalclustering.catchup.tx.TxStreamFinishedResponse;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.cursor.IOCursor;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class TxPullRequestHandler
extends SimpleChannelInboundHandler<TxPullRequest> {
    private final CatchupServerProtocol protocol;
    private final Supplier<StoreId> storeIdSupplier;
    private final BooleanSupplier databaseAvailable;
    private final TransactionIdStore transactionIdStore;
    private final LogicalTransactionStore logicalTransactionStore;
    private final TxPullRequestsMonitor monitor;
    private final Log log;

    public TxPullRequestHandler(CatchupServerProtocol protocol, Supplier<StoreId> storeIdSupplier, BooleanSupplier databaseAvailable, Supplier<TransactionIdStore> transactionIdStoreSupplier, Supplier<LogicalTransactionStore> logicalTransactionStoreSupplier, Monitors monitors, LogProvider logProvider) {
        this.protocol = protocol;
        this.storeIdSupplier = storeIdSupplier;
        this.databaseAvailable = databaseAvailable;
        this.transactionIdStore = transactionIdStoreSupplier.get();
        this.logicalTransactionStore = logicalTransactionStoreSupplier.get();
        this.monitor = (TxPullRequestsMonitor)monitors.newMonitor(TxPullRequestsMonitor.class, new String[0]);
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
    }

    protected void channelRead0(ChannelHandlerContext ctx, TxPullRequest msg) throws Exception {
        this.monitor.increment();
        long firstTxId = Math.max(msg.previousTxId(), 1L) + 1L;
        StoreId localStoreId = this.storeIdSupplier.get();
        StoreId expectedStoreId = msg.expectedStoreId();
        IOCursor<CommittedTransactionRepresentation> txCursor = this.getCursor(ctx, firstTxId, localStoreId, expectedStoreId);
        if (txCursor != null) {
            ctx.writeAndFlush((Object)new ChunkedTransactionStream(localStoreId, txCursor, this.protocol));
        }
    }

    private IOCursor<CommittedTransactionRepresentation> getCursor(ChannelHandlerContext ctx, long firstTxId, StoreId localStoreId, StoreId expectedStoreId) throws IOException {
        long lastCommittedTransactionId = this.transactionIdStore.getLastCommittedTransactionId();
        if (localStoreId == null || !localStoreId.equals(expectedStoreId)) {
            this.log.info("Failed to serve TxPullRequest for tx %d and storeId %s because that storeId is different from this machine with %s", new Object[]{firstTxId, expectedStoreId, localStoreId});
            this.endInteraction(ctx, CatchupResult.E_STORE_ID_MISMATCH, lastCommittedTransactionId);
            return null;
        }
        if (!this.databaseAvailable.getAsBoolean()) {
            this.log.info("Failed to serve TxPullRequest for tx %d because the local database is unavailable.", new Object[]{firstTxId});
            this.endInteraction(ctx, CatchupResult.E_STORE_UNAVAILABLE, lastCommittedTransactionId);
            return null;
        }
        if (lastCommittedTransactionId < firstTxId) {
            this.endInteraction(ctx, CatchupResult.SUCCESS_END_OF_STREAM, lastCommittedTransactionId);
            return null;
        }
        try {
            return this.logicalTransactionStore.getTransactions(firstTxId);
        }
        catch (NoSuchTransactionException e) {
            this.log.info("Failed to serve TxPullRequest for tx %d because the transaction does not exist.", new Object[]{firstTxId});
            this.endInteraction(ctx, CatchupResult.E_TRANSACTION_PRUNED, lastCommittedTransactionId);
            return null;
        }
    }

    private void endInteraction(ChannelHandlerContext ctx, CatchupResult status, long lastCommittedTransactionId) {
        ctx.write((Object)ResponseMessageType.TX_STREAM_FINISHED);
        ctx.writeAndFlush((Object)new TxStreamFinishedResponse(status, lastCommittedTransactionId));
        this.protocol.expect(CatchupServerProtocol.State.MESSAGE_TYPE);
    }
}

