/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import org.neo4j.causalclustering.catchup.ResponseMessageType;
import org.neo4j.causalclustering.catchup.storecopy.FileHeader;
import org.neo4j.causalclustering.catchup.storecopy.FileSender;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFinishedResponse;
import org.neo4j.causalclustering.catchup.storecopy.StoreResource;
import org.neo4j.cursor.RawCursor;

public class StoreStreamingProtocol {
    void stream(ChannelHandlerContext ctx, RawCursor<StoreResource, IOException> resources) throws IOException {
        while (resources.next()) {
            StoreResource resource = (StoreResource)resources.get();
            ctx.write((Object)ResponseMessageType.FILE);
            ctx.write((Object)new FileHeader(resource.path(), resource.recordSize()));
            ctx.write((Object)new FileSender(resource));
        }
    }

    Future<Void> end(ChannelHandlerContext ctx, StoreCopyFinishedResponse.Status status, long lastCommittedTxBeforeStoreCopy) {
        ctx.write((Object)ResponseMessageType.STORE_COPY_FINISHED);
        return ctx.writeAndFlush((Object)new StoreCopyFinishedResponse(status, lastCommittedTxBeforeStoreCopy));
    }
}

