/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.util.function.Supplier;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFinishedResponse;
import org.neo4j.causalclustering.catchup.storecopy.StoreResource;
import org.neo4j.causalclustering.catchup.storecopy.StoreResourceStreamFactory;
import org.neo4j.causalclustering.catchup.storecopy.StoreStreamingProtocol;
import org.neo4j.cursor.RawCursor;
import org.neo4j.graphdb.Resource;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;

public class StoreStreamingProcess {
    private final StoreStreamingProtocol protocol;
    private final Supplier<CheckPointer> checkPointerSupplier;
    private final StoreCopyCheckPointMutex mutex;
    private final StoreResourceStreamFactory resourceStreamFactory;

    public StoreStreamingProcess(StoreStreamingProtocol protocol, Supplier<CheckPointer> checkPointerSupplier, StoreCopyCheckPointMutex mutex, StoreResourceStreamFactory resourceStreamFactory) {
        this.protocol = protocol;
        this.checkPointerSupplier = checkPointerSupplier;
        this.mutex = mutex;
        this.resourceStreamFactory = resourceStreamFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void perform(ChannelHandlerContext ctx) throws IOException {
        CheckPointer checkPointer = this.checkPointerSupplier.get();
        Resource checkPointLock = this.mutex.storeCopy(() -> checkPointer.tryCheckPoint((TriggerInfo)new SimpleTriggerInfo("Store copy")));
        Future<Void> completion = null;
        try (RawCursor<StoreResource, IOException> resources = this.resourceStreamFactory.create();){
            this.protocol.stream(ctx, resources);
            completion = this.protocol.end(ctx, StoreCopyFinishedResponse.Status.SUCCESS, checkPointer.lastCheckPointedTransactionId());
        }
        finally {
            if (completion != null) {
                completion.addListener(f -> checkPointLock.close());
            } else {
                checkPointLock.close();
            }
        }
    }

    public void fail(ChannelHandlerContext ctx, StoreCopyFinishedResponse.Status failureCode) {
        this.protocol.end(ctx, failureCode, -1L);
    }
}

