/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import org.neo4j.causalclustering.catchup.storecopy.StoreResource;
import org.neo4j.cursor.RawCursor;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.storageengine.api.StoreFileMetadata;

public class StoreResourceStreamFactory {
    private final PageCache pageCache;
    private final FileSystemAbstraction fs;
    private final Supplier<NeoStoreDataSource> dataSourceSupplier;

    public StoreResourceStreamFactory(PageCache pageCache, FileSystemAbstraction fs, Supplier<NeoStoreDataSource> dataSourceSupplier) {
        this.pageCache = pageCache;
        this.fs = fs;
        this.dataSourceSupplier = dataSourceSupplier;
    }

    RawCursor<StoreResource, IOException> create() throws IOException {
        NeoStoreDataSource dataSource = this.dataSourceSupplier.get();
        final File storeDir = dataSource.getStoreDir();
        final ResourceIterator files = dataSource.listStoreFiles(false);
        return new RawCursor<StoreResource, IOException>(){
            private StoreResource resource;

            public StoreResource get() {
                return this.resource;
            }

            public boolean next() throws IOException {
                if (!files.hasNext()) {
                    this.resource = null;
                    return false;
                }
                StoreFileMetadata md = (StoreFileMetadata)files.next();
                this.resource = new StoreResource(md.file(), FileUtils.relativePath((File)storeDir, (File)md.file()), md.recordSize(), StoreResourceStreamFactory.this.pageCache, StoreResourceStreamFactory.this.fs);
                return true;
            }

            public void close() throws IOException {
                files.close();
            }
        };
    }
}

