/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;

class StoreResource
implements Closeable {
    private final File file;
    private final String path;
    private final int recordSize;
    private final PageCache pageCache;
    private final FileSystemAbstraction fs;
    private ReadableByteChannel channel;

    StoreResource(File file, String relativePath, int recordSize, PageCache pageCache, FileSystemAbstraction fs) {
        this.file = file;
        this.path = relativePath;
        this.recordSize = recordSize;
        this.pageCache = pageCache;
        this.fs = fs;
    }

    ReadableByteChannel open() throws IOException {
        Optional existingMapping = this.pageCache.getExistingMapping(this.file);
        if (existingMapping.isPresent()) {
            try (PagedFile pagedFile = (PagedFile)existingMapping.get();){
                this.channel = pagedFile.openReadableByteChannel();
            }
        } else {
            this.channel = this.fs.open(this.file, OpenMode.READ);
        }
        return this.channel;
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    public String path() {
        return this.path;
    }

    int recordSize() {
        return this.recordSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreResource that = (StoreResource)o;
        return this.recordSize == that.recordSize && Objects.equals(this.file, that.file) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.file, this.path, this.recordSize);
    }

    public String toString() {
        return "StoreResource{path='" + this.path + '\'' + ", channel=" + this.channel + ", recordSize=" + this.recordSize + '}';
    }
}

