/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.IOException;
import org.neo4j.causalclustering.catchup.CatchUpClientException;
import org.neo4j.causalclustering.catchup.CatchupResult;
import org.neo4j.causalclustering.catchup.TxPullRequestResult;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyClient;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.causalclustering.catchup.storecopy.StoreIdDownloadFailedException;
import org.neo4j.causalclustering.catchup.storecopy.StreamToDisk;
import org.neo4j.causalclustering.catchup.storecopy.StreamingTransactionsFailedException;
import org.neo4j.causalclustering.catchup.tx.TransactionLogCatchUpFactory;
import org.neo4j.causalclustering.catchup.tx.TransactionLogCatchUpWriter;
import org.neo4j.causalclustering.catchup.tx.TxPullClient;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class RemoteStore {
    private final Log log;
    private final Config config;
    private final Monitors monitors;
    private final FileSystemAbstraction fs;
    private final PageCache pageCache;
    private final LogProvider logProvider;
    private final StoreCopyClient storeCopyClient;
    private final TxPullClient txPullClient;
    private final TransactionLogCatchUpFactory transactionLogFactory;

    public RemoteStore(LogProvider logProvider, FileSystemAbstraction fs, PageCache pageCache, StoreCopyClient storeCopyClient, TxPullClient txPullClient, TransactionLogCatchUpFactory transactionLogFactory, Config config, Monitors monitors) {
        this.logProvider = logProvider;
        this.storeCopyClient = storeCopyClient;
        this.txPullClient = txPullClient;
        this.fs = fs;
        this.pageCache = pageCache;
        this.transactionLogFactory = transactionLogFactory;
        this.config = config;
        this.monitors = monitors;
        this.log = logProvider.getLog(this.getClass());
    }

    /*
     * Exception decompiling
     */
    private long getPullIndex(File storeDir) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public CatchupResult tryCatchingUp(AdvertisedSocketAddress from, StoreId expectedStoreId, File storeDir, boolean keepTxLogsInStoreDir) throws StoreCopyFailedException, IOException {
        long pullIndex = this.getPullIndex(storeDir);
        return this.pullTransactions(from, expectedStoreId, storeDir, pullIndex, false, keepTxLogsInStoreDir);
    }

    public void copy(AdvertisedSocketAddress from, StoreId expectedStoreId, File destDir) throws StoreCopyFailedException, StreamingTransactionsFailedException {
        try {
            long lastFlushedTxId;
            this.log.info("Copying store from %s", new Object[]{from});
            try (StreamToDisk storeFileStreams = new StreamToDisk(destDir, this.fs, this.pageCache, this.monitors);){
                lastFlushedTxId = this.storeCopyClient.copyStoreFiles(from, expectedStoreId, storeFileStreams);
            }
            this.log.info("Store files need to be recovered starting from: %d", new Object[]{lastFlushedTxId});
            CatchupResult catchupResult = this.pullTransactions(from, expectedStoreId, destDir, lastFlushedTxId, true, true);
            if (catchupResult != CatchupResult.SUCCESS_END_OF_STREAM) {
                throw new StreamingTransactionsFailedException("Failed to pull transactions: " + (Object)((Object)catchupResult));
            }
        }
        catch (IOException e) {
            throw new StoreCopyFailedException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CatchupResult pullTransactions(AdvertisedSocketAddress from, StoreId expectedStoreId, File storeDir, long fromTxId, boolean asPartOfStoreCopy, boolean keepTxLogsInStoreDir) throws IOException, StoreCopyFailedException {
        try (TransactionLogCatchUpWriter writer = this.transactionLogFactory.create(storeDir, this.fs, this.pageCache, this.config, this.logProvider, fromTxId, asPartOfStoreCopy, keepTxLogsInStoreDir);){
            CatchupResult lastStatus;
            this.log.info("Pulling transactions from: %d", new Object[]{fromTxId});
            long previousTxId = fromTxId - 1L;
            do {
                TxPullRequestResult result = this.txPullClient.pullTransactions(from, expectedStoreId, previousTxId, writer);
                lastStatus = result.catchupResult();
                previousTxId = result.lastTxId();
            } while (lastStatus == CatchupResult.SUCCESS_END_OF_BATCH);
            CatchupResult catchupResult = lastStatus;
            return catchupResult;
        }
        catch (CatchUpClientException e) {
            throw new StoreCopyFailedException(e);
        }
    }

    public StoreId getStoreId(AdvertisedSocketAddress from) throws StoreIdDownloadFailedException {
        return this.storeCopyClient.fetchStoreId(from);
    }
}

