/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.function.Supplier;
import org.neo4j.causalclustering.catchup.CatchupServerProtocol;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreRequest;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFinishedResponse;
import org.neo4j.causalclustering.catchup.storecopy.StoreStreamingProcess;
import org.neo4j.kernel.NeoStoreDataSource;

public class GetStoreRequestHandler
extends SimpleChannelInboundHandler<GetStoreRequest> {
    private final CatchupServerProtocol protocol;
    private final Supplier<NeoStoreDataSource> dataSource;
    private final StoreStreamingProcess storeStreamingProcess;

    public GetStoreRequestHandler(CatchupServerProtocol protocol, Supplier<NeoStoreDataSource> dataSource, StoreStreamingProcess storeStreamingProcess) {
        this.protocol = protocol;
        this.dataSource = dataSource;
        this.storeStreamingProcess = storeStreamingProcess;
    }

    protected void channelRead0(ChannelHandlerContext ctx, GetStoreRequest msg) throws Exception {
        if (!msg.expectedStoreId().equalToKernelStoreId(this.dataSource.get().getStoreId())) {
            this.storeStreamingProcess.fail(ctx, StoreCopyFinishedResponse.Status.E_STORE_ID_MISMATCH);
        } else {
            this.storeStreamingProcess.perform(ctx);
        }
        this.protocol.expect(CatchupServerProtocol.State.MESSAGE_TYPE);
    }
}

