/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering;

import java.io.File;
import java.time.Clock;
import java.time.Duration;
import java.util.UUID;
import org.neo4j.causalclustering.SessionTracker;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.ConsensusModule;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.replication.ProgressTrackerImpl;
import org.neo4j.causalclustering.core.replication.RaftReplicator;
import org.neo4j.causalclustering.core.replication.session.GlobalSession;
import org.neo4j.causalclustering.core.replication.session.GlobalSessionTrackerState;
import org.neo4j.causalclustering.core.replication.session.LocalSessionPool;
import org.neo4j.causalclustering.core.state.storage.DurableStateStorage;
import org.neo4j.causalclustering.helper.ConstantTimeTimeoutStrategy;
import org.neo4j.causalclustering.helper.ExponentialBackoffStrategy;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.Outbound;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;

public class ReplicationModule {
    public static final String SESSION_TRACKER_NAME = "session-tracker";
    private final RaftReplicator replicator;
    private final ProgressTrackerImpl progressTracker;
    private final SessionTracker sessionTracker;

    public ReplicationModule(MemberId myself, PlatformModule platformModule, Config config, ConsensusModule consensusModule, Outbound<MemberId, RaftMessages.RaftMessage> outbound, File clusterStateDirectory, FileSystemAbstraction fileSystem, LogProvider logProvider) {
        LifeSupport life = platformModule.life;
        DurableStateStorage sessionTrackerStorage = (DurableStateStorage)life.add(new DurableStateStorage<GlobalSessionTrackerState>(fileSystem, clusterStateDirectory, SESSION_TRACKER_NAME, new GlobalSessionTrackerState.Marshal(new MemberId.Marshal()), (Integer)config.get(CausalClusteringSettings.global_session_tracker_state_size), logProvider));
        this.sessionTracker = new SessionTracker(sessionTrackerStorage);
        GlobalSession myGlobalSession = new GlobalSession(UUID.randomUUID(), myself);
        LocalSessionPool sessionPool = new LocalSessionPool(myGlobalSession);
        this.progressTracker = new ProgressTrackerImpl(myGlobalSession);
        long replicationLimit = (Long)config.get(CausalClusteringSettings.replication_total_size_limit);
        Duration initialBackoff = (Duration)config.get(CausalClusteringSettings.replication_retry_timeout_base);
        Duration upperBoundBackoff = (Duration)config.get(CausalClusteringSettings.replication_retry_timeout_limit);
        Duration leaderBackoff = (Duration)config.get(CausalClusteringSettings.replication_leader_retry_timeout);
        ExponentialBackoffStrategy progressRetryStrategy = new ExponentialBackoffStrategy(initialBackoff, upperBoundBackoff);
        ConstantTimeTimeoutStrategy leaderRetryStrategy = new ConstantTimeTimeoutStrategy(leaderBackoff);
        this.replicator = (RaftReplicator)life.add((Lifecycle)new RaftReplicator(consensusModule.raftMachine(), myself, outbound, sessionPool, this.progressTracker, progressRetryStrategy, leaderRetryStrategy, platformModule.availabilityGuard, logProvider, replicationLimit, (Clock)platformModule.clock));
    }

    public RaftReplicator getReplicator() {
        return this.replicator;
    }

    public ProgressTrackerImpl getProgressTracker() {
        return this.progressTracker;
    }

    public SessionTracker getSessionTracker() {
        return this.sessionTracker;
    }
}

