/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.causalclustering;

import java.util.HashSet;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.ClusterMember;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.discovery.ReadReplica;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.HttpConnector;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.test.causalclustering.ClusterRule;

public class ClusterRuleIT {
    private static final int NumberOfPortsUsedByCoreMember = 6;
    private static final int NumberOfPortsUsedByReadReplica = 4;
    @Rule
    public final ClusterRule clusterRule = new ClusterRule();

    @Test
    public void shouldAssignPortsToMembersAutomatically() throws Exception {
        Cluster cluster = this.clusterRule.withNumberOfCoreMembers(3).withNumberOfReadReplicas(5).startCluster();
        int numberOfCoreMembers = cluster.coreMembers().size();
        Assert.assertThat((Object)numberOfCoreMembers, (Matcher)CoreMatchers.is((Object)3));
        int numberOfReadReplicas = cluster.readReplicas().size();
        Assert.assertThat((Object)numberOfReadReplicas, (Matcher)CoreMatchers.is((Object)5));
        Set<Integer> portsUsed = this.gatherPortsUsed(cluster);
        Assert.assertThat((Object)portsUsed.size(), (Matcher)CoreMatchers.is((Object)(numberOfCoreMembers * 6 + numberOfReadReplicas * 4)));
    }

    private Set<Integer> gatherPortsUsed(Cluster cluster) {
        HashSet<Integer> portsUsed = new HashSet<Integer>();
        for (CoreClusterMember coreClusterMember : cluster.coreMembers()) {
            portsUsed.add(this.getPortFromSetting(coreClusterMember, CausalClusteringSettings.discovery_listen_address.name()));
            portsUsed.add(this.getPortFromSetting(coreClusterMember, CausalClusteringSettings.transaction_listen_address.name()));
            portsUsed.add(this.getPortFromSetting(coreClusterMember, CausalClusteringSettings.raft_listen_address.name()));
            portsUsed.add(this.getPortFromSetting(coreClusterMember, OnlineBackupSettings.online_backup_server.name()));
            portsUsed.add(this.getPortFromSetting(coreClusterMember, new BoltConnector((String)"bolt").listen_address.name()));
            portsUsed.add(this.getPortFromSetting(coreClusterMember, new HttpConnector((String)"http").listen_address.name()));
        }
        for (ReadReplica readReplica : cluster.readReplicas()) {
            portsUsed.add(this.getPortFromSetting(readReplica, CausalClusteringSettings.transaction_listen_address.name()));
            portsUsed.add(this.getPortFromSetting(readReplica, OnlineBackupSettings.online_backup_server.name()));
            portsUsed.add(this.getPortFromSetting(readReplica, new BoltConnector((String)"bolt").listen_address.name()));
            portsUsed.add(this.getPortFromSetting(readReplica, new HttpConnector((String)"http").listen_address.name()));
        }
        return portsUsed;
    }

    private int getPortFromSetting(ClusterMember coreClusterMember, String settingName) {
        String setting = coreClusterMember.settingValue(settingName);
        return Integer.valueOf(setting.split(":")[1]);
    }
}

