/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.causalclustering;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntFunction;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.IpFamily;
import org.neo4j.causalclustering.discovery.SharedDiscoveryService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.test.rule.TestDirectory;

public class ClusterRule
extends ExternalResource {
    private final TestDirectory testDirectory;
    private File clusterDirectory;
    private Cluster cluster;
    private int noCoreMembers = 3;
    private int noReadReplicas = 3;
    private DiscoveryServiceFactory discoveryServiceFactory = new SharedDiscoveryService();
    private Map<String, String> coreParams = MapUtil.stringMap((String[])new String[0]);
    private Map<String, IntFunction<String>> instanceCoreParams = new HashMap<String, IntFunction<String>>();
    private Map<String, String> readReplicaParams = MapUtil.stringMap((String[])new String[0]);
    private Map<String, IntFunction<String>> instanceReadReplicaParams = new HashMap<String, IntFunction<String>>();
    private String recordFormat = "standard";
    private IpFamily ipFamily = IpFamily.IPV4;
    private boolean useWildcard;

    public ClusterRule() {
        this.testDirectory = TestDirectory.testDirectory();
    }

    public Statement apply(final Statement base, final Description description) {
        Statement testMethod = new Statement(){

            public void evaluate() throws Throwable {
                String name = description.getMethodName() != null ? description.getMethodName() : description.getClassName();
                ClusterRule.this.clusterDirectory = ClusterRule.this.testDirectory.directory(name);
                base.evaluate();
            }
        };
        Statement testMethodWithBeforeAndAfter = super.apply(testMethod, description);
        return this.testDirectory.apply(testMethodWithBeforeAndAfter, description);
    }

    protected void after() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    public Cluster startCluster() throws Exception {
        this.createCluster();
        this.cluster.start();
        this.cluster.awaitLeader();
        return this.cluster;
    }

    public Cluster createCluster() throws Exception {
        if (this.cluster == null) {
            this.cluster = new Cluster(this.clusterDirectory, this.noCoreMembers, this.noReadReplicas, this.discoveryServiceFactory, this.coreParams, this.instanceCoreParams, this.readReplicaParams, this.instanceReadReplicaParams, this.recordFormat, this.ipFamily, this.useWildcard);
        }
        return this.cluster;
    }

    public TestDirectory testDirectory() {
        return this.testDirectory;
    }

    public File clusterDirectory() {
        return this.clusterDirectory;
    }

    public ClusterRule withNumberOfCoreMembers(int noCoreMembers) {
        this.noCoreMembers = noCoreMembers;
        return this;
    }

    public ClusterRule withNumberOfReadReplicas(int noReadReplicas) {
        this.noReadReplicas = noReadReplicas;
        return this;
    }

    public ClusterRule withDiscoveryServiceFactory(DiscoveryServiceFactory factory) {
        this.discoveryServiceFactory = factory;
        return this;
    }

    public ClusterRule withSharedCoreParams(Map<String, String> params) {
        this.coreParams.putAll(params);
        return this;
    }

    public ClusterRule withSharedCoreParam(Setting<?> key, String value) {
        this.coreParams.put(key.name(), value);
        return this;
    }

    public ClusterRule withInstanceCoreParams(Map<String, IntFunction<String>> params) {
        this.instanceCoreParams.putAll(params);
        return this;
    }

    public ClusterRule withInstanceCoreParam(Setting<?> key, IntFunction<String> valueFunction) {
        this.instanceCoreParams.put(key.name(), valueFunction);
        return this;
    }

    public ClusterRule withSharedReadReplicaParams(Map<String, String> params) {
        this.readReplicaParams.putAll(params);
        return this;
    }

    public ClusterRule withSharedReadReplicaParam(Setting<?> key, String value) {
        this.readReplicaParams.put(key.name(), value);
        return this;
    }

    public ClusterRule withInstanceReadReplicaParams(Map<String, IntFunction<String>> params) {
        this.instanceReadReplicaParams.putAll(params);
        return this;
    }

    public ClusterRule withInstanceReadReplicaParam(Setting<?> key, IntFunction<String> valueFunction) {
        this.instanceReadReplicaParams.put(key.name(), valueFunction);
        return this;
    }

    public ClusterRule withRecordFormat(String recordFormat) {
        this.recordFormat = recordFormat;
        return this;
    }

    public ClusterRule withClusterDirectory(File clusterDirectory) {
        this.clusterDirectory = clusterDirectory;
        return this;
    }

    public ClusterRule withIpFamily(IpFamily ipFamily) {
        this.ipFamily = ipFamily;
        return this;
    }

    public ClusterRule useWildcard(boolean useWildcard) {
        this.useWildcard = useWildcard;
        return this;
    }
}

