/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.state.ClusterStateDirectory;
import org.neo4j.causalclustering.core.state.ClusterStateException;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.admin.Usage;
import org.neo4j.commandline.dbms.UnbindFromClusterCommand;
import org.neo4j.commandline.dbms.UnbindFromClusterCommandProvider;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class UnbindFromClusterCommandTest {
    private final TestDirectory testDir = TestDirectory.testDirectory();
    private final EphemeralFileSystemRule fileSystemRule = new EphemeralFileSystemRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fileSystemRule).around((TestRule)this.testDir);
    private Path homeDir;
    private Path confDir;
    private FileSystemAbstraction fs = new DefaultFileSystemAbstraction();
    private OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
    private FileChannel channel;

    @Before
    public void setup() throws ClusterStateException {
        this.homeDir = this.testDir.directory("home").toPath();
        this.confDir = this.testDir.directory("conf").toPath();
        this.fs.mkdir(this.homeDir.toFile());
        Mockito.when((Object)this.outsideWorld.fileSystem()).thenReturn((Object)this.fs);
    }

    @After
    public void tearDown() throws IOException {
        IOUtils.closeAll((AutoCloseable[])new FileChannel[]{this.channel});
    }

    private File createClusterStateDir(FileSystemAbstraction fs) throws ClusterStateException {
        File dataDir = new File(this.homeDir.toFile(), "data");
        ClusterStateDirectory clusterStateDirectory = new ClusterStateDirectory(dataDir, false);
        clusterStateDirectory.initialize(fs);
        return clusterStateDirectory.get();
    }

    @Test
    public void shouldIgnoreIfSpecifiedDatabaseDoesNotExist() throws Exception {
        File clusterStateDir = this.createClusterStateDir(this.fs);
        UnbindFromClusterCommand command = new UnbindFromClusterCommand(this.homeDir, this.confDir, this.outsideWorld);
        command.execute(this.databaseNameParameter("doesnotexist.db"));
        Assert.assertFalse((boolean)this.fs.fileExists(clusterStateDir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFailToUnbindLiveDatabase() throws Exception {
        this.createClusterStateDir(this.fs);
        UnbindFromClusterCommand command = new UnbindFromClusterCommand(this.homeDir, this.confDir, this.outsideWorld);
        FileLock fileLock = this.createLockedFakeDbDir(this.homeDir);
        try {
            command.execute(this.databaseNameParameter("graph.db"));
            Assert.fail();
        }
        catch (CommandFailed e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Database is currently locked. Please shutdown Neo4j."));
        }
        finally {
            fileLock.release();
        }
    }

    @Test
    public void shouldRemoveClusterStateDirectoryForGivenDatabase() throws Exception {
        File clusterStateDir = this.createClusterStateDir(this.fs);
        this.createUnlockedFakeDbDir(this.homeDir);
        UnbindFromClusterCommand command = new UnbindFromClusterCommand(this.homeDir, this.confDir, this.outsideWorld);
        command.execute(this.databaseNameParameter("graph.db"));
        Assert.assertFalse((boolean)this.fs.fileExists(clusterStateDir));
    }

    @Test
    public void shouldReportWhenClusterStateDirectoryIsNotPresent() throws Exception {
        this.createUnlockedFakeDbDir(this.homeDir);
        UnbindFromClusterCommand command = new UnbindFromClusterCommand(this.homeDir, this.confDir, this.outsideWorld);
        try {
            command.execute(this.databaseNameParameter("graph.db"));
        }
        catch (CommandFailed e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Cluster state directory does not exist"));
        }
    }

    @Test
    public void shouldPrintUsage() throws Throwable {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PrintStream ps = new PrintStream(baos);
            Usage usage = new Usage("neo4j-admin", (CommandLocator)Mockito.mock(CommandLocator.class));
            usage.printUsageForCommand((AdminCommand.Provider)new UnbindFromClusterCommandProvider(), ps::println);
            Assert.assertThat((Object)baos.toString(), (Matcher)Matchers.containsString((String)"usage"));
        }
    }

    private Path createUnlockedFakeDbDir(Path homeDir) throws IOException {
        Path fakeDbDir = this.createFakeDbDir(homeDir);
        Files.createFile(Paths.get(fakeDbDir.toString(), "store_lock"), new FileAttribute[0]);
        return fakeDbDir;
    }

    private FileLock createLockedFakeDbDir(Path homeDir) throws IOException {
        return this.createLockedStoreLockFileIn(this.createFakeDbDir(homeDir));
    }

    private Path createFakeDbDir(Path homeDir) throws IOException {
        Path graphDb = homeDir.resolve("data/databases/graph.db");
        this.fs.mkdirs(graphDb.toFile());
        this.fs.create(graphDb.resolve("neostore").toFile()).close();
        return graphDb;
    }

    private FileLock createLockedStoreLockFileIn(Path parent) throws IOException {
        Path storeLockFile = Files.createFile(Paths.get(parent.toString(), "store_lock"), new FileAttribute[0]);
        this.channel = FileChannel.open(storeLockFile, StandardOpenOption.READ, StandardOpenOption.WRITE);
        return this.channel.lock(0L, Long.MAX_VALUE, true);
    }

    private String[] databaseNameParameter(String databaseName) {
        return new String[]{"--database=" + databaseName};
    }
}

