/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntFunction;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.HazelcastDiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.IpFamily;
import org.neo4j.graphdb.Result;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.enterprise.api.security.EnterpriseSecurityContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.values.virtual.VirtualValues;

public class ServerGroupsIT {
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory();
    @Rule
    public DefaultFileSystemRule fsRule = new DefaultFileSystemRule();
    private Cluster cluster;

    @After
    public void after() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void shouldUpdateGroupsOnStart() throws Exception {
        AtomicReference<String> suffix = new AtomicReference<String>("before");
        HashMap<String, IntFunction<String>> instanceCoreParams = new HashMap<String, IntFunction<String>>();
        instanceCoreParams.put(CausalClusteringSettings.server_groups.name(), id -> String.join((CharSequence)", ", this.makeCoreGroups((String)suffix.get(), id)));
        HashMap<String, IntFunction<String>> instanceReplicaParams = new HashMap<String, IntFunction<String>>();
        instanceReplicaParams.put(CausalClusteringSettings.server_groups.name(), id -> String.join((CharSequence)", ", this.makeReplicaGroups((String)suffix.get(), id)));
        int nServers = 3;
        this.cluster = new Cluster(this.testDir.directory("cluster"), nServers, nServers, (DiscoveryServiceFactory)new HazelcastDiscoveryServiceFactory(), Collections.emptyMap(), instanceCoreParams, Collections.emptyMap(), instanceReplicaParams, "standard", IpFamily.IPV4, false);
        this.cluster.start();
        ArrayList<List<String>> expected = new ArrayList<List<String>>();
        for (CoreClusterMember core : this.cluster.coreMembers()) {
            expected.add(this.makeCoreGroups(suffix.get(), core.serverId()));
            expected.add(this.makeReplicaGroups(suffix.get(), core.serverId()));
        }
        for (CoreClusterMember core : this.cluster.coreMembers()) {
            Assert.assertEventually((String)(core + " should have groups"), () -> this.getServerGroups(core.database()), (Matcher)new GroupsMatcher(expected), (long)30L, (TimeUnit)TimeUnit.SECONDS);
        }
        expected.remove(this.makeCoreGroups(suffix.get(), 1));
        expected.remove(this.makeReplicaGroups(suffix.get(), 2));
        this.cluster.getCoreMemberById(1).shutdown();
        this.cluster.getReadReplicaById(2).shutdown();
        suffix.set("after");
        this.cluster.addCoreMemberWithId(1).start();
        this.cluster.addReadReplicaWithId(2).start();
        expected.add(this.makeCoreGroups(suffix.get(), 1));
        expected.add(this.makeReplicaGroups(suffix.get(), 2));
        for (CoreClusterMember core : this.cluster.coreMembers()) {
            Assert.assertEventually((String)(core + " should have groups"), () -> this.getServerGroups(core.database()), (Matcher)new GroupsMatcher(expected), (long)30L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    private List<String> makeCoreGroups(String suffix, int id) {
        return Arrays.asList(String.format("core-%d-%s", id, suffix), "core");
    }

    private List<String> makeReplicaGroups(String suffix, int id) {
        return Arrays.asList(String.format("replica-%d-%s", id, suffix), "replica");
    }

    private List<List<String>> getServerGroups(CoreGraphDatabase db) {
        ArrayList<List<String>> serverGroups = new ArrayList<List<String>>();
        try (InternalTransaction tx = db.beginTransaction(Transaction.Type.explicit, (SecurityContext)EnterpriseSecurityContext.AUTH_DISABLED);
             Result result = db.execute(tx, "CALL dbms.cluster.overview", VirtualValues.EMPTY_MAP);){
            while (result.hasNext()) {
                List groups = (List)result.next().get("groups");
                serverGroups.add(groups);
            }
        }
        return serverGroups;
    }

    class GroupsMatcher
    extends TypeSafeMatcher<List<List<String>>> {
        private final List<List<String>> expected;

        GroupsMatcher(List<List<String>> expected) {
            this.expected = expected;
        }

        protected boolean matchesSafely(List<List<String>> actual) {
            if (actual.size() != this.expected.size()) {
                return false;
            }
            for (List<String> actualGroups : actual) {
                boolean matched = false;
                for (List<String> expectedGroups : this.expected) {
                    if (actualGroups.size() != expectedGroups.size() || !actualGroups.containsAll(expectedGroups)) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.expected.toString());
        }
    }
}

