/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.io.File;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.causalclustering.ClusterRule;

public class RecoveryIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3).withNumberOfReadReplicas(0);

    @Test
    public void shouldBeConsistentAfterShutdown() throws Exception {
        Cluster cluster = this.clusterRule.startCluster();
        this.fireSomeLoadAtTheCluster(cluster);
        Set<File> storeDirs = cluster.coreMembers().stream().map(CoreClusterMember::storeDir).collect(Collectors.toSet());
        org.neo4j.test.assertion.Assert.assertEventually((String)"All cores have the same data", () -> cluster.coreMembers().stream().map(this::dbRepresentation).collect(Collectors.toSet()).size(), (Matcher)Matchers.equalTo((Object)1), (long)10L, (TimeUnit)TimeUnit.SECONDS);
        cluster.shutdown();
        storeDirs.forEach(this::assertConsistent);
    }

    @Test
    public void singleServerWithinClusterShouldBeConsistentAfterRestart() throws Exception {
        Cluster cluster = this.clusterRule.startCluster();
        int clusterSize = cluster.numberOfCoreMembersReportedByTopology();
        this.fireSomeLoadAtTheCluster(cluster);
        Set<File> storeDirs = cluster.coreMembers().stream().map(CoreClusterMember::storeDir).collect(Collectors.toSet());
        for (int i = 0; i < clusterSize; ++i) {
            cluster.removeCoreMemberWithMemberId(i);
            this.fireSomeLoadAtTheCluster(cluster);
            cluster.addCoreMemberWithId(i).start();
        }
        org.neo4j.test.assertion.Assert.assertEventually((String)"All cores have the same data", () -> cluster.coreMembers().stream().map(this::dbRepresentation).collect(Collectors.toSet()).size(), (Matcher)Matchers.equalTo((Object)1), (long)10L, (TimeUnit)TimeUnit.SECONDS);
        cluster.shutdown();
        storeDirs.forEach(this::assertConsistent);
    }

    private DbRepresentation dbRepresentation(CoreClusterMember member) {
        return DbRepresentation.of((GraphDatabaseService)member.database());
    }

    private void assertConsistent(File storeDir) {
        ConsistencyCheckService.Result result;
        try {
            result = new ConsistencyCheckService().runFullConsistencyCheck(storeDir, Config.defaults(), ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.getInstance(), true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Assert.assertTrue((boolean)result.isSuccessful());
    }

    private void fireSomeLoadAtTheCluster(Cluster cluster) throws Exception {
        for (int i = 0; i < cluster.numberOfCoreMembersReportedByTopology(); ++i) {
            String prop = "val" + i;
            cluster.coreTx((db, tx) -> {
                Node node = db.createNode(new Label[]{Label.label((String)"demo")});
                node.setProperty("server", (Object)prop);
                tx.success();
            });
        }
    }
}

