/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.HazelcastDiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.ReadReplica;
import org.neo4j.causalclustering.helpers.DataCreator;
import org.neo4j.causalclustering.scenarios.ReadReplicaToReadReplicaCatchupIT;
import org.neo4j.graphdb.Label;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.test.causalclustering.ClusterRule;

public class ReadReplicaHierarchicalCatchupIT {
    private Map<Integer, String> serverGroups = new HashMap<Integer, String>();
    @Rule
    public ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3).withNumberOfReadReplicas(0).withSharedCoreParam(CausalClusteringSettings.cluster_topology_refresh, "5s").withSharedCoreParam(CausalClusteringSettings.multi_dc_license, "true").withSharedReadReplicaParam(CausalClusteringSettings.multi_dc_license, "true").withDiscoveryServiceFactory((DiscoveryServiceFactory)new HazelcastDiscoveryServiceFactory());

    @Before
    public void setup() {
        this.serverGroups.put(0, "NORTH");
        this.serverGroups.put(1, "NORTH");
        this.serverGroups.put(2, "NORTH");
        this.serverGroups.put(3, "EAST");
        this.serverGroups.put(5, "EAST");
        this.serverGroups.put(4, "WEST");
        this.serverGroups.put(6, "WEST");
    }

    @Test
    public void shouldCatchupThroughHierarchy() throws Throwable {
        this.clusterRule = this.clusterRule.withInstanceReadReplicaParam(CausalClusteringSettings.server_groups, id -> this.serverGroups.get(id)).withInstanceCoreParam(CausalClusteringSettings.server_groups, id -> this.serverGroups.get(id));
        Cluster cluster = this.clusterRule.startCluster();
        int numberOfNodesToCreate = 100;
        cluster.coreTx((db, tx) -> {
            db.schema().constraintFor(Label.label((String)"Foo")).assertPropertyIsUnique("foobar").create();
            tx.success();
        });
        DataCreator.createLabelledNodesWithProperty(cluster, numberOfNodesToCreate, Label.label((String)"Foo"), () -> Pair.of((Object)"foobar", (Object)String.format("baz_bat%s", UUID.randomUUID())));
        ReadReplica east3 = cluster.addReadReplicaWithId(3);
        east3.start();
        ReadReplica west4 = cluster.addReadReplicaWithId(4);
        west4.start();
        ReadReplicaToReadReplicaCatchupIT.checkDataHasReplicatedToReadReplicas(cluster, numberOfNodesToCreate);
        for (CoreClusterMember coreClusterMember : cluster.coreMembers()) {
            coreClusterMember.stopCatchupServer();
        }
        ReadReplica east5 = cluster.addReadReplicaWithId(5);
        east5.setUpstreamDatabaseSelectionStrategy("connect-randomly-within-server-group");
        east5.start();
        ReadReplica west6 = cluster.addReadReplicaWithId(6);
        west6.setUpstreamDatabaseSelectionStrategy("connect-randomly-within-server-group");
        west6.start();
        ReadReplicaToReadReplicaCatchupIT.checkDataHasReplicatedToReadReplicas(cluster, numberOfNodesToCreate);
    }
}

