/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.time.Clock;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.test.Race;
import org.neo4j.test.causalclustering.ClusterRule;

public class PreElectionIT {
    @Rule
    public ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3).withNumberOfReadReplicas(0).withSharedCoreParam(CausalClusteringSettings.leader_election_timeout, "10s").withSharedCoreParam(CausalClusteringSettings.enable_pre_voting, "true");
    private Cluster cluster;

    @Before
    public void setUp() throws Exception {
        this.cluster = this.clusterRule.startCluster();
    }

    @Test
    public void shouldActuallyStartAClusterWithPreVoting() throws Exception {
    }

    @Test
    public void shouldStartAnElectionIfAllServersHaveTimedOutOnHeartbeats() throws Exception {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(this.cluster.coreMembers().size());
        long initialTerm = this.cluster.awaitLeader().raft().term();
        for (CoreClusterMember coreClusterMember : this.cluster.coreMembers()) {
            if (Role.FOLLOWER != coreClusterMember.raft().currentRole()) continue;
            futures.add(CompletableFuture.runAsync(Race.throwing(() -> member.raft().triggerElection(Clock.systemUTC()))));
        }
        org.neo4j.test.assertion.Assert.assertEventually((String)"Should be on a new term following an election", () -> this.cluster.awaitLeader().raft().term(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)initialTerm)), (long)1L, (TimeUnit)TimeUnit.MINUTES);
        for (CompletableFuture completableFuture : futures) {
            completableFuture.cancel(false);
        }
    }

    @Test
    public void shouldNotStartAnElectionIfAMinorityOfServersHaveTimedOutOnHeartbeats() throws Exception {
        CoreClusterMember follower = this.cluster.awaitCoreMemberWithRole(Role.FOLLOWER, 1L, TimeUnit.MINUTES);
        follower.raft().triggerElection(Clock.systemUTC());
        try {
            this.cluster.awaitCoreMemberWithRole(Role.CANDIDATE, 1L, TimeUnit.MINUTES);
            Assert.fail((String)"Should not have started an election if less than a quorum have timed out");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @Test
    public void shouldStartElectionIfLeaderRemoved() throws Exception {
        CoreClusterMember oldLeader = this.cluster.awaitLeader();
        this.cluster.removeCoreMember(oldLeader);
        CoreClusterMember newLeader = this.cluster.awaitLeader();
        Assert.assertThat((Object)newLeader.serverId(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)oldLeader.serverId())));
    }
}

