/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.io.File;
import java.io.IOException;
import java.time.Clock;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.scenarios.SampleData;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.causalclustering.ClusterRule;
import org.neo4j.time.Clocks;

public class CoreToCoreCopySnapshotIT {
    protected static final int NR_CORE_MEMBERS = 3;
    @Rule
    public final ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3).withNumberOfReadReplicas(0);

    @Test
    public void shouldBeAbleToDownloadLargerFreshSnapshot() throws Exception {
        Cluster cluster = this.clusterRule.startCluster();
        CoreClusterMember source = cluster.coreTx((db, tx) -> {
            SampleData.createData((GraphDatabaseService)db, 1000);
            tx.success();
        });
        CoreClusterMember follower = cluster.awaitCoreMemberWithRole(Role.FOLLOWER, 5L, TimeUnit.SECONDS);
        follower.shutdown();
        this.deleteDirectoryRecursively(follower.storeDir(), follower.serverId());
        this.deleteDirectoryRecursively(follower.clusterStateDirectory(), follower.serverId());
        follower.start();
        Assert.assertEquals((Object)DbRepresentation.of((GraphDatabaseService)source.database()), (Object)DbRepresentation.of((GraphDatabaseService)follower.database()));
    }

    protected void deleteDirectoryRecursively(File directory, int id) throws IOException {
        FileUtils.deleteRecursively((File)directory);
    }

    @Test
    public void shouldBeAbleToDownloadToNewInstanceAfterPruning() throws Exception {
        Map params = MapUtil.stringMap((String[])new String[]{CausalClusteringSettings.state_machine_flush_window_size.name(), "1", CausalClusteringSettings.raft_log_pruning_strategy.name(), "3 entries", CausalClusteringSettings.raft_log_rotation_size.name(), "1K"});
        Cluster cluster = this.clusterRule.withSharedCoreParams(params).startCluster();
        CoreClusterMember leader = cluster.coreTx((db, tx) -> {
            SampleData.createData((GraphDatabaseService)db, 10000);
            tx.success();
        });
        for (CoreClusterMember coreDb : cluster.coreMembers()) {
            coreDb.raftLogPruner().prune();
        }
        cluster.removeCoreMember(leader);
        leader = cluster.awaitLeader();
        int newDbId = 3;
        cluster.addCoreMemberWithId(newDbId).start();
        CoreGraphDatabase newDb = cluster.getCoreMemberById(newDbId).database();
        Assert.assertEquals((Object)DbRepresentation.of((GraphDatabaseService)leader.database()), (Object)DbRepresentation.of((GraphDatabaseService)newDb));
    }

    @Test
    public void shouldBeAbleToDownloadToRejoinedInstanceAfterPruning() throws Exception {
        CoreClusterMember secondServer;
        int oldestLogOnSecondServer;
        CoreClusterMember firstServer;
        int firstServerLogFileCount;
        Map coreParams = MapUtil.stringMap((String[])new String[0]);
        coreParams.put(CausalClusteringSettings.raft_log_rotation_size.name(), "1K");
        coreParams.put(CausalClusteringSettings.raft_log_pruning_strategy.name(), "keep_none");
        coreParams.put(CausalClusteringSettings.raft_log_pruning_frequency.name(), "100ms");
        coreParams.put(CausalClusteringSettings.state_machine_flush_window_size.name(), "64");
        int numberOfTransactions = 100;
        Timeout timeout = new Timeout(Clocks.systemClock(), 120L, TimeUnit.SECONDS);
        Cluster cluster = this.clusterRule.withSharedCoreParams(coreParams).startCluster();
        do {
            timeout.assertNotTimedOut();
        } while ((firstServerLogFileCount = this.getMostRecentLogIdOn(firstServer = this.doSomeTransactions(cluster, numberOfTransactions))) < 5);
        firstServer.shutdown();
        do {
            timeout.assertNotTimedOut();
        } while ((oldestLogOnSecondServer = this.getOldestLogIdOn(secondServer = this.doSomeTransactions(cluster, numberOfTransactions))) < firstServerLogFileCount + 5);
        firstServer.start();
        Cluster.dataOnMemberEventuallyLooksLike(firstServer, secondServer);
    }

    private int getOldestLogIdOn(CoreClusterMember clusterMember) throws TimeoutException, IOException {
        return clusterMember.getLogFileNames().firstKey().intValue();
    }

    private int getMostRecentLogIdOn(CoreClusterMember clusterMember) throws TimeoutException, IOException {
        return clusterMember.getLogFileNames().lastKey().intValue();
    }

    private CoreClusterMember doSomeTransactions(Cluster cluster, int count) {
        try {
            CoreClusterMember last = null;
            for (int i = 0; i < count; ++i) {
                last = cluster.coreTx((db, tx) -> {
                    Node node = db.createNode();
                    node.setProperty("that's a bam", (Object)this.string(1024));
                    tx.success();
                });
            }
            return last;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String string(int numberOfCharacters) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < numberOfCharacters; ++i) {
            s.append(String.valueOf(i));
        }
        return s.toString();
    }

    private class Timeout {
        private final Clock clock;
        private final long absoluteTimeoutMillis;

        Timeout(Clock clock, long time, TimeUnit unit) {
            this.clock = clock;
            this.absoluteTimeoutMillis = clock.millis() + unit.toMillis(time);
        }

        void assertNotTimedOut() {
            if (this.clock.millis() > this.absoluteTimeoutMillis) {
                throw new AssertionError((Object)"Timed out");
            }
        }
    }
}

