/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.catchup.CatchupServer;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.state.CoreSnapshotService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.causalclustering.ClusterRule;

public class ConnectionInfoIT {
    private Socket testSocket;
    @Rule
    public final ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3).withNumberOfReadReplicas(0);

    @After
    public void teardown() throws IOException {
        if (this.testSocket != null) {
            this.unbind(this.testSocket);
        }
    }

    @Test
    public void catchupServerMessage() throws Throwable {
        this.testSocket = this.bindPort("localhost", 4242);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        AssertableLogProvider userLogProvider = new AssertableLogProvider();
        CoreSnapshotService snapshotService = (CoreSnapshotService)Mockito.mock(CoreSnapshotService.class);
        Config config = Config.defaults((Setting)CausalClusteringSettings.transaction_listen_address, (String)(":" + this.testSocket.getLocalPort()));
        CatchupServer catchupServer = new CatchupServer((LogProvider)logProvider, (LogProvider)userLogProvider, this.mockSupplier(), this.mockSupplier(), this.mockSupplier(), this.mockSupplier(), (BooleanSupplier)Mockito.mock(BooleanSupplier.class), snapshotService, config, new Monitors(), this.mockSupplier(), (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class), (PageCache)Mockito.mock(PageCache.class), new StoreCopyCheckPointMutex(), null);
        try {
            catchupServer.start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        logProvider.assertContainsMessageContaining("Address is already bound for setting");
        userLogProvider.assertContainsMessageContaining("Address is already bound for setting");
    }

    private <T> Supplier<T> mockSupplier() {
        return (Supplier)Mockito.mock(Supplier.class);
    }

    private Socket bindPort(String address, int port) throws IOException {
        Socket socket = new Socket();
        socket.bind(new InetSocketAddress(address, port));
        return socket;
    }

    private void unbind(Socket socket) throws IOException {
        socket.close();
    }
}

