/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.WriteOperationsNotAllowedException;
import org.neo4j.test.causalclustering.ClusterRule;

@RunWith(value=Parameterized.class)
public class ClusterShutdownIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3).withNumberOfReadReplicas(0);
    @Parameterized.Parameter
    public Collection<Integer> shutdownOrder;

    @Parameterized.Parameters(name="shutdown order {0}")
    public static Collection<Collection<Integer>> shutdownOrders() {
        return Arrays.asList(Arrays.asList(0, 1, 2), Arrays.asList(1, 2, 0), Arrays.asList(2, 0, 1));
    }

    @Test
    public void shouldShutdownEvenThoughWaitingForLock() throws Exception {
        Cluster cluster = this.clusterRule.startCluster();
        try {
            for (int victimId = 0; victimId < cluster.numberOfCoreMembersReportedByTopology(); ++victimId) {
                TestCase.assertTrue((boolean)cluster.getCoreMemberById(victimId).database().isAvailable(1000L));
                this.shouldShutdownEvenThoughWaitingForLock0(cluster, victimId, this.shutdownOrder);
                cluster.start();
            }
        }
        catch (WriteOperationsNotAllowedException writeOperationsNotAllowedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shouldShutdownEvenThoughWaitingForLock0(Cluster cluster, int victimId, Collection<Integer> shutdownOrder) throws Exception {
        int LONG_TIME = 60000;
        int LONGER_TIME = 120000;
        int NUMBER_OF_LOCK_ACQUIRERS = 2;
        ExecutorService txExecutor = Executors.newCachedThreadPool();
        ExecutorService shutdownExecutor = Executors.newFixedThreadPool(1);
        try {
            AtomicReference<Node> someNode = new AtomicReference<Node>();
            CoreGraphDatabase victimDB = cluster.getCoreMemberById(victimId).database();
            try (Transaction tx = victimDB.beginTx();){
                someNode.set(victimDB.createNode());
                tx.success();
            }
            AtomicInteger numberOfInstancesReady = new AtomicInteger();
            for (int i = 0; i < 2; ++i) {
                txExecutor.execute(() -> ClusterShutdownIT.lambda$shouldShutdownEvenThoughWaitingForLock0$0((GraphDatabaseService)victimDB, numberOfInstancesReady, someNode));
            }
            while (numberOfInstancesReady.get() < 2) {
                Thread.sleep(100L);
            }
            CountDownLatch shutdownLatch = new CountDownLatch(cluster.numberOfCoreMembersReportedByTopology());
            for (int id : shutdownOrder) {
                shutdownExecutor.execute(() -> {
                    cluster.getCoreMemberById(id).shutdown();
                    shutdownLatch.countDown();
                });
            }
            if (!shutdownLatch.await(60000L, TimeUnit.MILLISECONDS)) {
                TestCase.fail((String)"Cluster didn't shut down in a timely fashion.");
            }
        }
        finally {
            txExecutor.shutdownNow();
            shutdownExecutor.shutdownNow();
        }
    }

    private static /* synthetic */ void lambda$shouldShutdownEvenThoughWaitingForLock0$0(GraphDatabaseService victimDB, AtomicInteger numberOfInstancesReady, AtomicReference someNode) {
        try (Transaction tx = victimDB.beginTx();){
            numberOfInstancesReady.incrementAndGet();
            tx.acquireWriteLock((PropertyContainer)someNode.get());
            Thread.sleep(120000L);
            tx.success();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

