/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.ClusterMember;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.HazelcastDiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.SharedDiscoveryService;
import org.neo4j.causalclustering.discovery.procedures.Role;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.InwardKernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.causalclustering.ClusterRule;

@RunWith(value=Parameterized.class)
public class ClusterOverviewIT {
    @Rule
    public ClusterRule clusterRule = new ClusterRule().withSharedCoreParam(CausalClusteringSettings.cluster_topology_refresh, "5s");

    @Parameterized.Parameters(name="discovery-{0}")
    public static Collection<DiscoveryService> data() {
        return Arrays.asList(DiscoveryService.SHARED, DiscoveryService.HAZELCAST);
    }

    public ClusterOverviewIT(DiscoveryService discoveryService) {
        switch (discoveryService) {
            case SHARED: {
                this.clusterRule.withDiscoveryServiceFactory(new SharedDiscoveryService());
                break;
            }
            case HAZELCAST: {
                this.clusterRule.withDiscoveryServiceFactory((DiscoveryServiceFactory)new HazelcastDiscoveryServiceFactory());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Test
    public void shouldDiscoverCoreMembers() throws Exception {
        this.clusterRule.withNumberOfCoreMembers(3);
        this.clusterRule.withNumberOfReadReplicas(0);
        Cluster cluster = this.clusterRule.startCluster();
        Matcher expected = Matchers.allOf(this.containsMemberAddresses(cluster.coreMembers()), this.containsRole(Role.LEADER, 1L), this.containsRole(Role.FOLLOWER, 2L), this.doesNotContainRole(Role.READ_REPLICA));
        for (int coreServerId = 0; coreServerId < 3; ++coreServerId) {
            this.assertEventualOverview(cluster, (Matcher<List<MemberInfo>>)expected, coreServerId);
        }
    }

    @Test
    public void shouldDiscoverCoreMembersAndReadReplicas() throws Exception {
        this.clusterRule.withNumberOfCoreMembers(3);
        this.clusterRule.withNumberOfReadReplicas(3);
        Cluster cluster = this.clusterRule.startCluster();
        Matcher expected = Matchers.allOf(this.containsAllMemberAddresses(cluster.coreMembers(), cluster.readReplicas()), this.containsRole(Role.LEADER, 1L), this.containsRole(Role.FOLLOWER, 2L), this.containsRole(Role.READ_REPLICA, 3L));
        for (int coreServerId = 0; coreServerId < 3; ++coreServerId) {
            this.assertEventualOverview(cluster, (Matcher<List<MemberInfo>>)expected, coreServerId);
        }
    }

    @Test
    public void shouldDiscoverReadReplicasAfterRestartingCores() throws Exception {
        this.clusterRule.withNumberOfCoreMembers(3);
        this.clusterRule.withNumberOfReadReplicas(3);
        Cluster cluster = this.clusterRule.startCluster();
        cluster.shutdownCoreMembers();
        cluster.startCoreMembers();
        Matcher expected = Matchers.allOf(this.containsAllMemberAddresses(cluster.coreMembers(), cluster.readReplicas()), this.containsRole(Role.LEADER, 1L), this.containsRole(Role.FOLLOWER, 2L), this.containsRole(Role.READ_REPLICA, 3L));
        for (int coreServerId = 0; coreServerId < 3; ++coreServerId) {
            this.assertEventualOverview(cluster, (Matcher<List<MemberInfo>>)expected, coreServerId);
        }
    }

    @Test
    public void shouldDiscoverNewCoreMembers() throws Exception {
        this.clusterRule.withNumberOfCoreMembers(3);
        this.clusterRule.withNumberOfReadReplicas(0);
        Cluster cluster = this.clusterRule.startCluster();
        cluster.addCoreMemberWithId(3).start();
        cluster.addCoreMemberWithId(4).start();
        Matcher expected = Matchers.allOf(this.containsMemberAddresses(cluster.coreMembers()), this.containsRole(Role.LEADER, 1L), this.containsRole(Role.FOLLOWER, 4L));
        for (int coreServerId = 0; coreServerId < 5; ++coreServerId) {
            this.assertEventualOverview(cluster, (Matcher<List<MemberInfo>>)expected, coreServerId);
        }
    }

    @Test
    public void shouldDiscoverNewReadReplicas() throws Exception {
        this.clusterRule.withNumberOfCoreMembers(3);
        this.clusterRule.withNumberOfReadReplicas(3);
        Cluster cluster = this.clusterRule.startCluster();
        cluster.addReadReplicaWithId(3).start();
        cluster.addReadReplicaWithId(4).start();
        Matcher expected = Matchers.allOf(this.containsAllMemberAddresses(cluster.coreMembers(), cluster.readReplicas()), this.containsRole(Role.LEADER, 1L), this.containsRole(Role.FOLLOWER, 2L), this.containsRole(Role.READ_REPLICA, 5L));
        for (int coreServerId = 0; coreServerId < 3; ++coreServerId) {
            this.assertEventualOverview(cluster, (Matcher<List<MemberInfo>>)expected, coreServerId);
        }
    }

    @Test
    public void shouldDiscoverRemovalOfReadReplicas() throws Exception {
        int coreServerId;
        this.clusterRule.withNumberOfCoreMembers(3);
        this.clusterRule.withNumberOfReadReplicas(3);
        Cluster cluster = this.clusterRule.startCluster();
        for (coreServerId = 0; coreServerId < 3; ++coreServerId) {
            this.assertEventualOverview(cluster, this.containsRole(Role.READ_REPLICA, 3L), coreServerId);
        }
        cluster.removeReadReplicaWithMemberId(0);
        cluster.removeReadReplicaWithMemberId(1);
        for (coreServerId = 0; coreServerId < 3; ++coreServerId) {
            this.assertEventualOverview(cluster, this.containsRole(Role.READ_REPLICA, 1L), coreServerId);
        }
    }

    @Test
    public void shouldDiscoverRemovalOfCoreMembers() throws Exception {
        int coreServerId;
        this.clusterRule.withNumberOfCoreMembers(5);
        this.clusterRule.withNumberOfReadReplicas(0);
        Cluster cluster = this.clusterRule.startCluster();
        for (coreServerId = 0; coreServerId < 5; ++coreServerId) {
            this.assertEventualOverview(cluster, (Matcher<List<MemberInfo>>)Matchers.allOf(this.containsRole(Role.LEADER, 1L), this.containsRole(Role.FOLLOWER, 4L)), coreServerId);
        }
        cluster.removeCoreMemberWithMemberId(0);
        cluster.removeCoreMemberWithMemberId(1);
        for (coreServerId = 2; coreServerId < 5; ++coreServerId) {
            this.assertEventualOverview(cluster, (Matcher<List<MemberInfo>>)Matchers.allOf(this.containsRole(Role.LEADER, 1L), this.containsRole(Role.FOLLOWER, 2L)), coreServerId);
        }
    }

    private void assertEventualOverview(Cluster cluster, Matcher<List<MemberInfo>> expected, int coreServerId) throws KernelException, InterruptedException {
        Assert.assertEventually((String)("should have overview from core " + coreServerId), () -> this.clusterOverview((GraphDatabaseFacade)cluster.getCoreMemberById(coreServerId).database()), expected, (long)60L, (TimeUnit)TimeUnit.SECONDS);
    }

    @SafeVarargs
    private final Matcher<Iterable<? extends MemberInfo>> containsAllMemberAddresses(Collection<? extends ClusterMember> ... members) {
        return this.containsMemberAddresses(Stream.of(members).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    private Matcher<Iterable<? extends MemberInfo>> containsMemberAddresses(Collection<? extends ClusterMember> members) {
        return Matchers.containsInAnyOrder((Collection)members.stream().map(coreClusterMember -> new TypeSafeMatcher<MemberInfo>(){

            protected boolean matchesSafely(MemberInfo item) {
                Set addresses = Iterators.asSet((Object[])item.addresses);
                for (URI uri : coreClusterMember.clientConnectorAddresses().uriList()) {
                    if (addresses.contains(uri.toString())) continue;
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("MemberInfo with addresses: ").appendValue((Object)coreClusterMember.clientConnectorAddresses().boltAddress());
            }
        }).collect(Collectors.toList()));
    }

    private Matcher<List<MemberInfo>> containsRole(final Role expectedRole, long expectedCount) {
        return new FeatureMatcher<List<MemberInfo>, Long>(Matchers.equalTo((Object)expectedCount), expectedRole.name(), "count"){

            protected Long featureValueOf(List<MemberInfo> overview) {
                return overview.stream().filter(info -> ((MemberInfo)info).role == expectedRole).count();
            }
        };
    }

    private Matcher<List<MemberInfo>> doesNotContainRole(Role unexpectedRole) {
        return this.containsRole(unexpectedRole, 0L);
    }

    private List<MemberInfo> clusterOverview(GraphDatabaseFacade db) throws TransactionFailureException, ProcedureException {
        InwardKernel kernel = (InwardKernel)db.getDependencyResolver().resolveDependency(InwardKernel.class);
        KernelTransaction transaction = kernel.newTransaction(Transaction.Type.implicit, (SecurityContext)AnonymousContext.read());
        ArrayList<MemberInfo> infos = new ArrayList<MemberInfo>();
        try (Statement statement = transaction.acquireStatement();){
            RawIterator itr = statement.procedureCallOperations().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"dbms", "cluster", "overview"}), null);
            while (itr.hasNext()) {
                Object[] row = (Object[])itr.next();
                List addresses = (List)row[1];
                infos.add(new MemberInfo(addresses.toArray(new String[addresses.size()]), Role.valueOf((String)((String)row[2]))));
            }
        }
        return infos;
    }

    private static class MemberInfo {
        private final String[] addresses;
        private final Role role;

        MemberInfo(String[] addresses, Role role) {
            this.addresses = addresses;
            this.role = role;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MemberInfo that = (MemberInfo)o;
            return Arrays.equals(this.addresses, that.addresses) && this.role == that.role;
        }

        public int hashCode() {
            return Objects.hash(this.addresses, this.role);
        }

        public String toString() {
            return String.format("MemberInfo{addresses='%s', role=%s}", Arrays.toString(this.addresses), this.role);
        }
    }

    private static enum DiscoveryService {
        SHARED,
        HAZELCAST;

    }
}

