/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.mutable.MutableLong;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.id.IdController;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.test.causalclustering.ClusterRule;

public class ClusterIdReuseIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3).withSharedCoreParam(CausalClusteringSettings.leader_election_timeout, "2s").withSharedCoreParam(GraphDatabaseSettings.record_id_batch_size, Integer.toString(1)).withNumberOfReadReplicas(0);
    private Cluster cluster;

    @Test
    public void shouldReuseIdsInCluster() throws Exception {
        this.cluster = this.clusterRule.startCluster();
        MutableLong first = new MutableLong();
        MutableLong second = new MutableLong();
        CoreClusterMember leader1 = this.createThreeNodes(this.cluster, first, second);
        CoreClusterMember leader2 = this.removeTwoNodes(this.cluster, first, second);
        Assume.assumeTrue((leader1 != null && leader1.equals(leader2) ? 1 : 0) != 0);
        this.idMaintenanceOnLeader(leader1);
        IdGeneratorFactory idGeneratorFactory = this.resolveDependency(leader1, IdGeneratorFactory.class);
        IdGenerator idGenerator = idGeneratorFactory.get(IdType.NODE);
        Assert.assertEquals((long)2L, (long)idGenerator.getDefragCount());
        MutableLong node1id = new MutableLong();
        MutableLong node2id = new MutableLong();
        MutableLong node3id = new MutableLong();
        CoreClusterMember clusterMember = this.cluster.coreTx((db, tx) -> {
            Node node1 = db.createNode();
            Node node2 = db.createNode();
            Node node3 = db.createNode();
            node1id.setValue(node1.getId());
            node2id.setValue(node2.getId());
            node3id.setValue(node3.getId());
            tx.success();
        });
        Assume.assumeTrue((boolean)leader1.equals(clusterMember));
        Assert.assertEquals((long)first.longValue(), (long)node1id.longValue());
        Assert.assertEquals((long)second.longValue(), (long)node2id.longValue());
        Assert.assertEquals((long)idGenerator.getHighestPossibleIdInUse(), (long)node3id.longValue());
    }

    @Test
    public void newLeaderShouldNotReuseIds() throws Exception {
        this.cluster = this.clusterRule.startCluster();
        MutableLong first = new MutableLong();
        MutableLong second = new MutableLong();
        CoreClusterMember creationLeader = this.createThreeNodes(this.cluster, first, second);
        CoreClusterMember deletionLeader = this.removeTwoNodes(this.cluster, first, second);
        Assume.assumeTrue((creationLeader != null && creationLeader.equals(deletionLeader) ? 1 : 0) != 0);
        this.idMaintenanceOnLeader(creationLeader);
        IdGeneratorFactory idGeneratorFactory = this.resolveDependency(creationLeader, IdGeneratorFactory.class);
        IdGenerator creationLeaderIdGenerator = idGeneratorFactory.get(IdType.NODE);
        Assert.assertEquals((long)2L, (long)creationLeaderIdGenerator.getDefragCount());
        this.cluster.removeCoreMemberWithMemberId(creationLeader.serverId());
        CoreClusterMember newLeader = this.cluster.awaitLeader();
        Assert.assertNotSame((Object)creationLeader.serverId(), (Object)newLeader.serverId());
        this.idMaintenanceOnLeader(newLeader);
        IdGeneratorFactory newLeaderIdGeneratorFactory = this.resolveDependency(newLeader, IdGeneratorFactory.class);
        IdGenerator idGenerator = newLeaderIdGeneratorFactory.get(IdType.NODE);
        Assert.assertEquals((long)0L, (long)idGenerator.getDefragCount());
        CoreClusterMember newCreationLeader = this.cluster.coreTx((db, tx) -> {
            Node node = db.createNode();
            Assert.assertEquals((long)idGenerator.getHighestPossibleIdInUse(), (long)node.getId());
            tx.success();
        });
        Assume.assumeTrue((boolean)newLeader.equals(newCreationLeader));
    }

    @Test
    public void reusePreviouslyFreedIds() throws Exception {
        this.cluster = this.clusterRule.startCluster();
        MutableLong first = new MutableLong();
        MutableLong second = new MutableLong();
        CoreClusterMember creationLeader = this.createThreeNodes(this.cluster, first, second);
        CoreClusterMember deletionLeader = this.removeTwoNodes(this.cluster, first, second);
        Assume.assumeTrue((creationLeader != null && creationLeader.equals(deletionLeader) ? 1 : 0) != 0);
        IdGeneratorFactory idGeneratorFactory = this.resolveDependency(creationLeader, IdGeneratorFactory.class);
        this.idMaintenanceOnLeader(creationLeader);
        IdGenerator creationLeaderIdGenerator = idGeneratorFactory.get(IdType.NODE);
        Assert.assertEquals((long)2L, (long)creationLeaderIdGenerator.getDefragCount());
        this.cluster.removeCoreMemberWithMemberId(creationLeader.serverId());
        this.cluster.addCoreMemberWithId(creationLeader.serverId()).start();
        CoreClusterMember leader = this.cluster.awaitLeader();
        while (leader.serverId() != creationLeader.serverId()) {
            this.cluster.removeCoreMemberWithMemberId(leader.serverId());
            this.cluster.addCoreMemberWithId(leader.serverId()).start();
            leader = this.cluster.awaitLeader();
        }
        this.idMaintenanceOnLeader(leader);
        IdGeneratorFactory leaderIdGeneratorFactory = this.resolveDependency(leader, IdGeneratorFactory.class);
        creationLeaderIdGenerator = leaderIdGeneratorFactory.get(IdType.NODE);
        Assert.assertEquals((long)2L, (long)creationLeaderIdGenerator.getDefragCount());
        MutableLong node1id = new MutableLong();
        MutableLong node2id = new MutableLong();
        CoreClusterMember reuseLeader = this.cluster.coreTx((db, tx) -> {
            Node node1 = db.createNode();
            Node node2 = db.createNode();
            node1id.setValue(node1.getId());
            node2id.setValue(node2.getId());
            tx.success();
        });
        Assume.assumeTrue((boolean)leader.equals(reuseLeader));
        Assert.assertEquals((long)first.longValue(), (long)node1id.longValue());
        Assert.assertEquals((long)second.longValue(), (long)node2id.longValue());
    }

    private void idMaintenanceOnLeader(CoreClusterMember leader) throws TimeoutException {
        IdController idController = this.resolveDependency(leader, IdController.class);
        idController.maintenance();
    }

    private <T> T resolveDependency(CoreClusterMember leader, Class<T> clazz) {
        return (T)leader.database().getDependencyResolver().resolveDependency(clazz);
    }

    private CoreClusterMember removeTwoNodes(Cluster cluster, MutableLong first, MutableLong second) throws Exception {
        return cluster.coreTx((db, tx) -> {
            Node node1 = db.getNodeById(first.longValue());
            node1.delete();
            db.getNodeById(second.longValue()).delete();
            tx.success();
        });
    }

    private CoreClusterMember createThreeNodes(Cluster cluster, MutableLong first, MutableLong second) throws Exception {
        return cluster.coreTx((db, tx) -> {
            Node node1 = db.createNode();
            first.setValue(node1.getId());
            Node node2 = db.createNode();
            second.setValue(node2.getId());
            db.createNode();
            tx.success();
        });
    }
}

