/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.discovery.ReadReplica;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.test.causalclustering.ClusterRule;

public class ClusterCustomLogLocationIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3).withNumberOfReadReplicas(2);

    @Test
    public void clusterWithCustomTransactionLogLocation() throws Exception {
        Cluster cluster = this.clusterRule.startCluster();
        for (int i = 0; i < 10; ++i) {
            cluster.coreTx((db, tx) -> {
                db.createNode();
                tx.success();
            });
        }
        Collection<CoreClusterMember> coreClusterMembers = cluster.coreMembers();
        for (CoreClusterMember coreClusterMember : coreClusterMembers) {
            DependencyResolver dependencyResolver = coreClusterMember.database().getDependencyResolver();
            LogFiles logFiles = (LogFiles)dependencyResolver.resolveDependency(LogFiles.class);
            Assert.assertEquals((Object)logFiles.logFilesDirectory().getName(), (Object)("core-tx-logs-" + coreClusterMember.serverId()));
            Assert.assertTrue((boolean)logFiles.hasAnyEntries(0L));
            File[] coreLogDirectories = coreClusterMember.storeDir().listFiles(file -> file.getName().startsWith("core"));
            Assert.assertThat((Object)coreLogDirectories, (Matcher)Matchers.arrayWithSize((int)1));
            this.logFileInStoreDirectoryDoesNotExist(coreClusterMember.storeDir(), dependencyResolver);
        }
        Collection<ReadReplica> readReplicas = cluster.readReplicas();
        for (ReadReplica readReplica : readReplicas) {
            readReplica.txPollingClient().upToDateFuture().get();
            DependencyResolver dependencyResolver = readReplica.database().getDependencyResolver();
            LogFiles logFiles = (LogFiles)dependencyResolver.resolveDependency(LogFiles.class);
            Assert.assertEquals((Object)logFiles.logFilesDirectory().getName(), (Object)("replica-tx-logs-" + readReplica.serverId()));
            Assert.assertTrue((boolean)logFiles.hasAnyEntries(0L));
            File[] replicaLogDirectories = readReplica.storeDir().listFiles(file -> file.getName().startsWith("replica"));
            Assert.assertThat((Object)replicaLogDirectories, (Matcher)Matchers.arrayWithSize((int)1));
            this.logFileInStoreDirectoryDoesNotExist(readReplica.storeDir(), dependencyResolver);
        }
    }

    private void logFileInStoreDirectoryDoesNotExist(File storeDir, DependencyResolver dependencyResolver) throws IOException {
        FileSystemAbstraction fileSystem = (FileSystemAbstraction)dependencyResolver.resolveDependency(FileSystemAbstraction.class);
        LogFiles storeLogFiles = LogFilesBuilder.logFilesBasedOnlyBuilder((File)storeDir, (FileSystemAbstraction)fileSystem).build();
        Assert.assertFalse((boolean)storeLogFiles.versionExists(0L));
    }
}

