/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.io.File;
import java.util.Collections;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.IpFamily;
import org.neo4j.causalclustering.discovery.SharedDiscoveryService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class ClusterCommunityToEnterpriseIT {
    private Cluster cluster;
    private FileSystemAbstraction fsa;
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory();
    @Rule
    public DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();

    @Before
    public void setup() throws Exception {
        this.fsa = this.fileSystemRule.get();
        this.cluster = new Cluster(this.testDir.directory("cluster"), 3, 0, new SharedDiscoveryService(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), "high_limit", IpFamily.IPV4, false);
    }

    @After
    public void after() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void shouldRestoreBySeedingAllMembers() throws Throwable {
        File storeDir = this.testDir.makeGraphDbDir();
        GraphDatabaseService database = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(storeDir).setConfig(GraphDatabaseSettings.allow_upgrade, "true").setConfig(GraphDatabaseSettings.record_format, "high_limit").setConfig(OnlineBackupSettings.online_backup_enabled, Boolean.FALSE.toString()).newGraphDatabase();
        database.shutdown();
        Config config = Config.defaults((Setting)OnlineBackupSettings.online_backup_enabled, (String)"false");
        DbRepresentation before = DbRepresentation.of((File)storeDir, (Config)config);
        this.fsa.copyRecursively(storeDir, this.cluster.getCoreMemberById(0).storeDir());
        this.fsa.copyRecursively(storeDir, this.cluster.getCoreMemberById(1).storeDir());
        this.fsa.copyRecursively(storeDir, this.cluster.getCoreMemberById(2).storeDir());
        this.cluster.start();
        Cluster.dataMatchesEventually(before, this.cluster.coreMembers());
    }
}

