/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.readreplica;

import java.util.ArrayList;
import java.util.UUID;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.readreplica.ConnectToRandomCoreServerStrategyTest;
import org.neo4j.causalclustering.readreplica.TypicallyConnectToRandomReadReplicaStrategy;
import org.neo4j.causalclustering.readreplica.UserDefinedConfigurationStrategyTest;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class TypicallyConnectToRandomReadReplicaStrategyTest {
    @Test
    public void shouldConnectToCoreOneInTenTimesByDefault() throws Exception {
        MemberId theCoreMemberId = new MemberId(UUID.randomUUID());
        TopologyService topologyService = UserDefinedConfigurationStrategyTest.fakeTopologyService(ConnectToRandomCoreServerStrategyTest.fakeCoreTopology(theCoreMemberId), UserDefinedConfigurationStrategyTest.fakeReadReplicaTopology(UserDefinedConfigurationStrategyTest.memberIDs(100)));
        TypicallyConnectToRandomReadReplicaStrategy connectionStrategy = new TypicallyConnectToRandomReadReplicaStrategy();
        connectionStrategy.inject(topologyService, null, (LogProvider)NullLogProvider.getInstance(), null);
        ArrayList responses = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            responses.add(connectionStrategy.upstreamDatabase().get());
        }
        Assert.assertThat(responses, (Matcher)CoreMatchers.hasItem((Object)theCoreMemberId));
    }
}

