/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.readreplica;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.catchup.storecopy.RemoteStore;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyProcess;
import org.neo4j.causalclustering.catchup.storecopy.StoreIdDownloadFailedException;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.helper.ConstantTimeTimeoutStrategy;
import org.neo4j.causalclustering.helper.TimeoutStrategy;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.causalclustering.readreplica.ReadReplicaStartupProcess;
import org.neo4j.causalclustering.readreplica.UpstreamDatabaseSelectionException;
import org.neo4j.causalclustering.readreplica.UpstreamDatabaseSelectionStrategy;
import org.neo4j.causalclustering.readreplica.UpstreamDatabaseStrategySelector;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class ReadReplicaStartupProcessTest {
    private ConstantTimeTimeoutStrategy retryStrategy = new ConstantTimeTimeoutStrategy(1L, TimeUnit.MILLISECONDS);
    private StoreCopyProcess storeCopyProcess = (StoreCopyProcess)Mockito.mock(StoreCopyProcess.class);
    private RemoteStore remoteStore = (RemoteStore)Mockito.mock(RemoteStore.class);
    private final PageCache pageCache = (PageCache)Mockito.mock(PageCache.class);
    private LocalDatabase localDatabase = (LocalDatabase)Mockito.mock(LocalDatabase.class);
    private TopologyService topologyService = (TopologyService)Mockito.mock(TopologyService.class);
    private CoreTopology clusterTopology = (CoreTopology)Mockito.mock(CoreTopology.class);
    private Lifecycle txPulling = (Lifecycle)Mockito.mock(Lifecycle.class);
    private MemberId memberId = new MemberId(UUID.randomUUID());
    private AdvertisedSocketAddress fromAddress = new AdvertisedSocketAddress("127.0.0.1", 123);
    private StoreId localStoreId = new StoreId(1L, 2L, 3L, 4L);
    private StoreId otherStoreId = new StoreId(5L, 6L, 7L, 8L);
    private File storeDir = new File("store-dir");

    @Before
    public void commonMocking() throws StoreIdDownloadFailedException, IOException {
        HashMap<MemberId, Object> members = new HashMap<MemberId, Object>();
        members.put(this.memberId, Mockito.mock(CoreServerInfo.class));
        FileSystemAbstraction fileSystemAbstraction = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        Mockito.when((Object)fileSystemAbstraction.streamFilesRecursive((File)ArgumentMatchers.any(File.class))).thenAnswer(f -> Stream.empty());
        Mockito.when((Object)this.pageCache.getCachedFileSystem()).thenReturn((Object)fileSystemAbstraction);
        Mockito.when((Object)this.localDatabase.storeDir()).thenReturn((Object)this.storeDir);
        Mockito.when((Object)this.localDatabase.storeId()).thenReturn((Object)this.localStoreId);
        Mockito.when((Object)this.topologyService.coreServers()).thenReturn((Object)this.clusterTopology);
        Mockito.when((Object)this.clusterTopology.members()).thenReturn(members);
        Mockito.when((Object)this.topologyService.findCatchupAddress(this.memberId)).thenReturn(Optional.of(this.fromAddress));
    }

    @Test
    public void shouldReplaceEmptyStoreWithRemote() throws Throwable {
        Mockito.when((Object)this.localDatabase.isEmpty()).thenReturn((Object)true);
        Mockito.when((Object)this.topologyService.findCatchupAddress((MemberId)ArgumentMatchers.any())).thenReturn(Optional.of(this.fromAddress));
        Mockito.when((Object)this.remoteStore.getStoreId((AdvertisedSocketAddress)ArgumentMatchers.any())).thenReturn((Object)this.otherStoreId);
        ReadReplicaStartupProcess readReplicaStartupProcess = new ReadReplicaStartupProcess(this.remoteStore, this.localDatabase, this.txPulling, this.chooseFirstMember(), (TimeoutStrategy)this.retryStrategy, (LogProvider)NullLogProvider.getInstance(), (LogProvider)NullLogProvider.getInstance(), this.storeCopyProcess, this.topologyService);
        readReplicaStartupProcess.start();
        ((StoreCopyProcess)Mockito.verify((Object)this.storeCopyProcess)).replaceWithStoreFrom((AdvertisedSocketAddress)ArgumentMatchers.any(), (StoreId)ArgumentMatchers.any());
        ((LocalDatabase)Mockito.verify((Object)this.localDatabase)).start();
        ((Lifecycle)Mockito.verify((Object)this.txPulling)).start();
    }

    private UpstreamDatabaseStrategySelector chooseFirstMember() {
        AlwaysChooseFirstMember firstMember = new AlwaysChooseFirstMember();
        firstMember.inject(this.topologyService, null, (LogProvider)NullLogProvider.getInstance(), null);
        return new UpstreamDatabaseStrategySelector((UpstreamDatabaseSelectionStrategy)firstMember);
    }

    @Test
    public void shouldNotStartWithMismatchedNonEmptyStore() throws Throwable {
        Mockito.when((Object)this.localDatabase.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)this.remoteStore.getStoreId((AdvertisedSocketAddress)ArgumentMatchers.any())).thenReturn((Object)this.otherStoreId);
        ReadReplicaStartupProcess readReplicaStartupProcess = new ReadReplicaStartupProcess(this.remoteStore, this.localDatabase, this.txPulling, this.chooseFirstMember(), (TimeoutStrategy)this.retryStrategy, (LogProvider)NullLogProvider.getInstance(), (LogProvider)NullLogProvider.getInstance(), this.storeCopyProcess, this.topologyService);
        try {
            readReplicaStartupProcess.start();
            Assert.fail((String)"should have thrown");
        }
        catch (Exception ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"This read replica cannot join the cluster. The local database is not empty and has a mismatching storeId"));
        }
        ((Lifecycle)Mockito.verify((Object)this.txPulling, (VerificationMode)Mockito.never())).start();
    }

    @Test
    public void shouldStartWithMatchingDatabase() throws Throwable {
        Mockito.when((Object)this.remoteStore.getStoreId((AdvertisedSocketAddress)ArgumentMatchers.any())).thenReturn((Object)this.localStoreId);
        Mockito.when((Object)this.localDatabase.isEmpty()).thenReturn((Object)false);
        ReadReplicaStartupProcess readReplicaStartupProcess = new ReadReplicaStartupProcess(this.remoteStore, this.localDatabase, this.txPulling, this.chooseFirstMember(), (TimeoutStrategy)this.retryStrategy, (LogProvider)NullLogProvider.getInstance(), (LogProvider)NullLogProvider.getInstance(), this.storeCopyProcess, this.topologyService);
        readReplicaStartupProcess.start();
        ((LocalDatabase)Mockito.verify((Object)this.localDatabase)).start();
        ((Lifecycle)Mockito.verify((Object)this.txPulling)).start();
    }

    @Test
    public void stopShouldStopTheDatabaseAndStopPolling() throws Throwable {
        Mockito.when((Object)this.remoteStore.getStoreId((AdvertisedSocketAddress)ArgumentMatchers.any())).thenReturn((Object)this.localStoreId);
        Mockito.when((Object)this.localDatabase.isEmpty()).thenReturn((Object)false);
        ReadReplicaStartupProcess readReplicaStartupProcess = new ReadReplicaStartupProcess(this.remoteStore, this.localDatabase, this.txPulling, this.chooseFirstMember(), (TimeoutStrategy)this.retryStrategy, (LogProvider)NullLogProvider.getInstance(), (LogProvider)NullLogProvider.getInstance(), this.storeCopyProcess, this.topologyService);
        readReplicaStartupProcess.start();
        readReplicaStartupProcess.stop();
        ((Lifecycle)Mockito.verify((Object)this.txPulling)).stop();
        ((LocalDatabase)Mockito.verify((Object)this.localDatabase)).stop();
    }

    public static class AlwaysChooseFirstMember
    extends UpstreamDatabaseSelectionStrategy {
        public AlwaysChooseFirstMember() {
            super("always-choose-first-member", new String[0]);
        }

        public Optional<MemberId> upstreamDatabase() throws UpstreamDatabaseSelectionException {
            CoreTopology coreTopology = this.topologyService.coreServers();
            return Optional.ofNullable(coreTopology.members().keySet().iterator().next());
        }
    }
}

