/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.readreplica;

import co.unruly.matchers.OptionalMatchers;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.readreplica.ConnectRandomlyToServerGroupImpl;
import org.neo4j.causalclustering.readreplica.ConnectToRandomCoreServerStrategyTest;
import org.neo4j.causalclustering.readreplica.UserDefinedConfigurationStrategyTest;
import org.neo4j.helpers.AdvertisedSocketAddress;

public class ConnectRandomlyToServerGroupStrategyImplTest {
    @Test
    public void shouldStayWithinGivenSingleServerGroup() throws Exception {
        List<String> myServerGroup = Collections.singletonList("my_server_group");
        Object[] myGroupMemberIds = UserDefinedConfigurationStrategyTest.memberIDs(10);
        TopologyService topologyService = ConnectRandomlyToServerGroupStrategyImplTest.getTopologyService(myServerGroup, (MemberId[])myGroupMemberIds, Collections.singletonList("your_server_group"));
        ConnectRandomlyToServerGroupImpl strategy = new ConnectRandomlyToServerGroupImpl(myServerGroup, topologyService, myGroupMemberIds[0]);
        Optional memberId = strategy.upstreamDatabase();
        MatcherAssert.assertThat((Object)memberId, (Matcher)OptionalMatchers.contains((Matcher)Matchers.isIn((Object[])myGroupMemberIds)));
    }

    @Test
    public void shouldSelectAnyFromMultipleServerGroups() throws Exception {
        List<String> myServerGroups = Arrays.asList("a", "b", "c");
        Object[] myGroupMemberIds = UserDefinedConfigurationStrategyTest.memberIDs(10);
        TopologyService topologyService = ConnectRandomlyToServerGroupStrategyImplTest.getTopologyService(myServerGroups, (MemberId[])myGroupMemberIds, Arrays.asList("x", "y", "z"));
        ConnectRandomlyToServerGroupImpl strategy = new ConnectRandomlyToServerGroupImpl(myServerGroups, topologyService, myGroupMemberIds[0]);
        Optional memberId = strategy.upstreamDatabase();
        MatcherAssert.assertThat((Object)memberId, (Matcher)OptionalMatchers.contains((Matcher)Matchers.isIn((Object[])myGroupMemberIds)));
    }

    @Test
    public void shouldReturnEmptyIfNoGroupsInConfig() throws Exception {
        MemberId[] myGroupMemberIds = UserDefinedConfigurationStrategyTest.memberIDs(10);
        TopologyService topologyService = ConnectRandomlyToServerGroupStrategyImplTest.getTopologyService(Collections.singletonList("my_server_group"), myGroupMemberIds, Arrays.asList("x", "y", "z"));
        ConnectRandomlyToServerGroupImpl strategy = new ConnectRandomlyToServerGroupImpl(Collections.emptyList(), topologyService, null);
        Optional memberId = strategy.upstreamDatabase();
        MatcherAssert.assertThat((Object)memberId, (Matcher)OptionalMatchers.empty());
    }

    @Test
    public void shouldReturnEmptyIfGroupOnlyContainsSelf() throws Exception {
        List<String> myServerGroup = Collections.singletonList("group");
        MemberId[] myGroupMemberIds = UserDefinedConfigurationStrategyTest.memberIDs(1);
        TopologyService topologyService = ConnectRandomlyToServerGroupStrategyImplTest.getTopologyService(myServerGroup, myGroupMemberIds, Arrays.asList("x", "y", "z"));
        ConnectRandomlyToServerGroupImpl strategy = new ConnectRandomlyToServerGroupImpl(myServerGroup, topologyService, myGroupMemberIds[0]);
        Optional memberId = strategy.upstreamDatabase();
        MatcherAssert.assertThat((Object)memberId, (Matcher)OptionalMatchers.empty());
    }

    static TopologyService getTopologyService(List<String> myServerGroups, MemberId[] myGroupMemberIds, List<String> unwanted) {
        return UserDefinedConfigurationStrategyTest.fakeTopologyService(ConnectToRandomCoreServerStrategyTest.fakeCoreTopology(new MemberId(UUID.randomUUID())), ConnectRandomlyToServerGroupStrategyImplTest.fakeReadReplicaTopology(myServerGroups, myGroupMemberIds, unwanted, 10));
    }

    static ReadReplicaTopology fakeReadReplicaTopology(List<String> wanted, MemberId[] memberIds, List<String> unwanted, int unwantedNumber) {
        HashMap<MemberId, ReadReplicaInfo> readReplicas = new HashMap<MemberId, ReadReplicaInfo>();
        int offset = 0;
        for (MemberId memberId : memberIds) {
            readReplicas.put(memberId, new ReadReplicaInfo(new ClientConnectorAddresses(Collections.singletonList(new ClientConnectorAddresses.ConnectorUri(ClientConnectorAddresses.Scheme.bolt, new AdvertisedSocketAddress("localhost", 11000 + offset)))), new AdvertisedSocketAddress("localhost", 10000 + offset), new HashSet<String>(wanted)));
            ++offset;
        }
        for (int i = 0; i < unwantedNumber; ++i) {
            readReplicas.put(new MemberId(UUID.randomUUID()), new ReadReplicaInfo(new ClientConnectorAddresses(Collections.singletonList(new ClientConnectorAddresses.ConnectorUri(ClientConnectorAddresses.Scheme.bolt, new AdvertisedSocketAddress("localhost", 11000 + offset)))), new AdvertisedSocketAddress("localhost", 10000 + offset), new HashSet<String>(unwanted)));
            ++offset;
        }
        return new ReadReplicaTopology(readReplicas);
    }
}

