/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

class TestServer {
    private final int port;
    private final ChildHandler childHandler;
    private EventLoopGroup elg;
    private ChannelFuture fServer;

    TestServer(int port) {
        this(port, null);
    }

    private TestServer(int port, ChannelInitializer<SocketChannel> channelInitializer) {
        this.port = port;
        this.childHandler = new ChildHandler(channelInitializer);
    }

    void start() {
        this.elg = new NioEventLoopGroup(0);
        ServerBootstrap boot = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(NioServerSocketChannel.class)).option(ChannelOption.SO_REUSEADDR, (Object)Boolean.TRUE)).childHandler((ChannelHandler)this.childHandler).group(this.elg);
        this.fServer = boot.bind(this.port);
        this.fServer.syncUninterruptibly();
    }

    void stop() {
        if (this.elg != null) {
            this.fServer.channel().close().syncUninterruptibly();
            this.childHandler.closeAll();
            this.elg.shutdownGracefully().syncUninterruptibly();
            this.elg = null;
        }
    }

    int childCount() {
        return this.childHandler.channels.size();
    }

    class ChildHandler
    extends ChannelInitializer<SocketChannel> {
        private final ChannelInitializer<SocketChannel> delegate;
        private final Set<Channel> channels = new ConcurrentSkipListSet<Channel>();

        ChildHandler(ChannelInitializer<SocketChannel> delegate) {
            this.delegate = delegate;
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            super.handlerAdded(ctx);
            if (this.delegate != null) {
                this.delegate.handlerAdded(ctx);
            }
        }

        protected void initChannel(SocketChannel ch) throws Exception {
            this.channels.add((Channel)ch);
            ch.closeFuture().addListener(future -> this.channels.remove(ch));
        }

        void closeAll() {
            this.channels.forEach(channel -> channel.close().syncUninterruptibly());
        }
    }
}

