/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.causalclustering.messaging.NonBlockingChannel;
import org.neo4j.causalclustering.messaging.TestServer;
import org.neo4j.helpers.SocketAddress;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.ports.allocation.PortAuthority;

public class NonBlockingChannelIT {
    private static final int PORT = PortAuthority.allocatePort();
    private static final ChannelHandler VOID_HANDLER = new ChannelInitializer<SocketChannel>(){

        protected void initChannel(SocketChannel ch) throws Exception {
        }
    };
    private static final long DEFAULT_TIMEOUT_MS = 20000L;
    private final Log log = NullLogProvider.getInstance().getLog(this.getClass());
    private final SocketAddress serverAddress = new SocketAddress("localhost", PORT);
    private final TestServer server = new TestServer(PORT);
    private EventLoopGroup elg;
    private NonBlockingChannel channel;

    @Before
    public void before() {
        this.elg = new NioEventLoopGroup(0);
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(NioSocketChannel.class)).group(this.elg)).handler(VOID_HANDLER);
        this.channel = new NonBlockingChannel(bootstrap, this.elg.next(), this.serverAddress, this.log);
    }

    @After
    public void after() {
        this.elg.shutdownGracefully(0L, 20000L, TimeUnit.MILLISECONDS).awaitUninterruptibly();
        this.server.stop();
    }

    @Test
    public void shouldBeAbleToSendMessage() throws Exception {
        this.server.start();
        this.channel.start();
        Future fSend = this.channel.send((Object)this.emptyBuffer());
        Assert.assertTrue((boolean)fSend.await(20000L));
        Assert.assertNull((Object)fSend.cause());
    }

    @Test
    public void shouldAllowDeferredSend() throws Exception {
        this.channel.start();
        this.server.start();
        Future fSend = this.channel.send((Object)this.emptyBuffer());
        Assert.assertTrue((boolean)fSend.await(20000L));
        Assert.assertNull((Object)fSend.cause());
        Assert.assertTrue((boolean)fSend.isSuccess());
    }

    @Test
    public void shouldFailSendWhenNoServer() throws Exception {
        this.channel.start();
        Future fSend = this.channel.send((Object)this.emptyBuffer());
        Assert.assertTrue((boolean)fSend.await(20000L));
        Assert.assertFalse((boolean)fSend.isSuccess());
    }

    @Test
    public void shouldReconnectAfterServerComesBack() throws Exception {
        this.server.start();
        this.channel.start();
        Future fSend = this.channel.send((Object)this.emptyBuffer());
        Assert.assertTrue((boolean)fSend.awaitUninterruptibly(20000L));
        Assert.assertNull((Object)fSend.cause());
        this.server.stop();
        fSend = this.channel.send((Object)this.emptyBuffer());
        Assert.assertTrue((boolean)fSend.await(20000L));
        Assert.assertFalse((boolean)fSend.isSuccess());
        this.server.start();
        fSend = this.channel.send((Object)this.emptyBuffer());
        Assert.assertTrue((boolean)fSend.await(20000L));
        Assert.assertTrue((boolean)fSend.isSuccess());
    }

    @Test
    public void shouldNotAllowSendingOnDisposedChannel() throws Exception {
        this.server.start();
        this.channel.start();
        Future fSend = this.channel.send((Object)this.emptyBuffer());
        fSend.await(20000L);
        Assert.assertTrue((boolean)fSend.isSuccess());
        org.neo4j.test.assertion.Assert.assertEventually((String)"", this.server::childCount, (Matcher)CoreMatchers.equalTo((Object)1), (long)20000L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.channel.dispose();
        try {
            this.channel.send((Object)this.emptyBuffer());
        }
        catch (IllegalStateException illegalStateException) {
        }
        org.neo4j.test.assertion.Assert.assertEventually((String)"", this.server::childCount, (Matcher)CoreMatchers.equalTo((Object)0), (long)20000L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private ByteBuf emptyBuffer() {
        return ByteBufAllocator.DEFAULT.buffer();
    }
}

