/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.load_balancing.procedure;

import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.causalclustering.load_balancing.LoadBalancingPlugin;
import org.neo4j.causalclustering.load_balancing.LoadBalancingProcessor;
import org.neo4j.causalclustering.load_balancing.procedure.GetServersProcedureForMultiDC;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.proc.FieldSignature;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.api.proc.ProcedureSignature;

public class GetServersProcedureV2Test {
    @Test
    public void shouldHaveCorrectSignature() throws Exception {
        GetServersProcedureForMultiDC proc = new GetServersProcedureForMultiDC(null);
        ProcedureSignature signature = proc.signature();
        MatcherAssert.assertThat((Object)signature.inputSignature(), (Matcher)Matchers.containsInAnyOrder((Object[])new FieldSignature[]{FieldSignature.inputField((String)"context", (Neo4jTypes.AnyType)Neo4jTypes.NTMap)}));
        MatcherAssert.assertThat((Object)signature.outputSignature(), (Matcher)Matchers.containsInAnyOrder((Object[])new FieldSignature[]{FieldSignature.outputField((String)"ttl", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger), FieldSignature.outputField((String)"servers", (Neo4jTypes.AnyType)Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTMap))}));
    }

    @Test
    public void shouldPassClientContextToPlugin() throws Exception {
        LoadBalancingPlugin plugin = (LoadBalancingPlugin)Mockito.mock(LoadBalancingPlugin.class);
        Mockito.when((Object)plugin.run(ArgumentMatchers.anyMap())).thenReturn(Mockito.mock(LoadBalancingProcessor.Result.class));
        GetServersProcedureForMultiDC getServers = new GetServersProcedureForMultiDC((LoadBalancingProcessor)plugin);
        Map clientContext = MapUtil.stringMap((String[])new String[]{"key", "value", "key2", "value2"});
        getServers.apply(null, new Object[]{clientContext});
        ((LoadBalancingPlugin)Mockito.verify((Object)plugin)).run(clientContext);
    }
}

