/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.load_balancing.plugins.server_policies;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.load_balancing.filters.Filter;
import org.neo4j.causalclustering.load_balancing.plugins.server_policies.FilterBuilder;
import org.neo4j.causalclustering.load_balancing.plugins.server_policies.FilteringPolicy;
import org.neo4j.causalclustering.load_balancing.plugins.server_policies.FilteringPolicyLoader;
import org.neo4j.causalclustering.load_balancing.plugins.server_policies.Policies;
import org.neo4j.causalclustering.load_balancing.plugins.server_policies.Policy;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;

public class FilteringPolicyLoaderTest {
    @Test
    public void shouldLoadConfiguredPolicies() throws Exception {
        String pluginName = "server_policies";
        Object[][] input = new Object[][]{{"asia_west", "groups(asia_west) -> min(2);groups(asia) -> min(2);", FilterBuilder.filter().groups("asia_west").min(2).newRule().groups("asia").min(2).newRule().all().build()}, {"asia_east", "groups(asia_east) -> min(2);groups(asia) -> min(2);", FilterBuilder.filter().groups("asia_east").min(2).newRule().groups("asia").min(2).newRule().all().build()}, {"asia_only", "groups(asia);halt();", FilterBuilder.filter().groups("asia").build()}};
        Config config = Config.defaults();
        for (Object[] row : input) {
            String policyName = (String)row[0];
            String filterSpec = (String)row[1];
            config.augment(FilteringPolicyLoaderTest.configNameFor(pluginName, policyName), filterSpec);
        }
        Policies policies = FilteringPolicyLoader.load((Config)config, (String)pluginName, (Log)((Log)Mockito.mock(Log.class)));
        for (Object[] row : input) {
            String policyName = (String)row[0];
            Policy loadedPolicy = policies.selectFor(FilteringPolicyLoaderTest.policyNameContext(policyName));
            FilteringPolicy expectedPolicy = new FilteringPolicy((Filter)row[2]);
            Assert.assertEquals((Object)expectedPolicy, (Object)loadedPolicy);
        }
    }

    private static Map<String, String> policyNameContext(String policyName) {
        return MapUtil.stringMap((String[])new String[]{"policy", policyName});
    }

    private static String configNameFor(String pluginName, String policyName) {
        return String.format("%s.%s.%s", CausalClusteringSettings.load_balancing_config.name(), pluginName, policyName);
    }
}

