/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.load_balancing.plugins.server_policies;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.load_balancing.plugins.server_policies.AnyGroupFilter;
import org.neo4j.causalclustering.load_balancing.plugins.server_policies.ServerInfo;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.collection.Iterators;

public class AnyGroupFilterTest {
    @Test
    public void shouldReturnServersMatchingAnyGroup() throws Exception {
        AnyGroupFilter groupFilter = new AnyGroupFilter(Iterators.asSet((Object[])new String[]{"china-west", "europe"}));
        ServerInfo serverA = new ServerInfo(new AdvertisedSocketAddress("bolt", 1), new MemberId(UUID.randomUUID()), Iterators.asSet((Object[])new String[]{"china-west"}));
        ServerInfo serverB = new ServerInfo(new AdvertisedSocketAddress("bolt", 2), new MemberId(UUID.randomUUID()), Iterators.asSet((Object[])new String[]{"europe"}));
        ServerInfo serverC = new ServerInfo(new AdvertisedSocketAddress("bolt", 3), new MemberId(UUID.randomUUID()), Iterators.asSet((Object[])new String[]{"china", "china-west"}));
        ServerInfo serverD = new ServerInfo(new AdvertisedSocketAddress("bolt", 4), new MemberId(UUID.randomUUID()), Iterators.asSet((Object[])new String[]{"china-west", "china"}));
        ServerInfo serverE = new ServerInfo(new AdvertisedSocketAddress("bolt", 5), new MemberId(UUID.randomUUID()), Iterators.asSet((Object[])new String[]{"china-east", "asia"}));
        ServerInfo serverF = new ServerInfo(new AdvertisedSocketAddress("bolt", 6), new MemberId(UUID.randomUUID()), Iterators.asSet((Object[])new String[]{"europe-west"}));
        ServerInfo serverG = new ServerInfo(new AdvertisedSocketAddress("bolt", 7), new MemberId(UUID.randomUUID()), Iterators.asSet((Object[])new String[]{"china-west", "europe"}));
        ServerInfo serverH = new ServerInfo(new AdvertisedSocketAddress("bolt", 8), new MemberId(UUID.randomUUID()), Iterators.asSet((Object[])new String[]{"africa"}));
        Set data = Iterators.asSet((Object[])new ServerInfo[]{serverA, serverB, serverC, serverD, serverE, serverF, serverG, serverH});
        Set output = groupFilter.apply(data);
        HashSet<Integer> ports = new HashSet<Integer>();
        for (ServerInfo info : output) {
            ports.add(info.boltAddress().getPort());
        }
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Integer[]{1, 2, 3, 4, 7}), ports);
    }
}

