/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.load_balancing.filters;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.load_balancing.filters.Filter;
import org.neo4j.causalclustering.load_balancing.filters.FilterChain;
import org.neo4j.causalclustering.load_balancing.filters.FirstValidRule;
import org.neo4j.helpers.collection.Iterators;

public class FirstValidRuleTest {
    @Test
    public void shouldUseResultOfFirstNonEmpty() throws Exception {
        Filter removeValuesOfFive = data -> data.stream().filter(value -> value != 5).collect(Collectors.toSet());
        Filter countMoreThanFour = data -> data.size() > 4 ? data : Collections.emptySet();
        Filter countMoreThanThree = data -> data.size() > 3 ? data : Collections.emptySet();
        FilterChain ruleA = new FilterChain(Arrays.asList(removeValuesOfFive, countMoreThanFour));
        FilterChain ruleB = new FilterChain(Arrays.asList(removeValuesOfFive, countMoreThanThree));
        FilterChain ruleC = new FilterChain(Collections.singletonList(countMoreThanFour));
        FirstValidRule firstValidRule = new FirstValidRule(Arrays.asList(ruleA, ruleB, ruleC));
        Set data2 = Iterators.asSet((Object[])new Integer[]{5, 1, 5, 2, 5, 3, 5, 4});
        data2 = firstValidRule.apply(data2);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Integer[]{1, 2, 3, 4}), (Object)data2);
    }
}

